/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CapacityDistributionStrategy {
    BALANCED_ONLY("balanced-only"),
    BALANCED_BEST_EFFORT("balanced-best-effort"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CapacityDistributionStrategy> VALUE_MAP;
    private final String value;

    private CapacityDistributionStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CapacityDistributionStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CapacityDistributionStrategy> knownValues() {
        EnumSet<CapacityDistributionStrategy> knownValues = EnumSet.allOf(CapacityDistributionStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CapacityDistributionStrategy.class, CapacityDistributionStrategy::toString);
    }
}

