/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.PredictiveScalingForecastTimestampsCopier;
import software.amazon.awssdk.services.autoscaling.model.PredictiveScalingForecastValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapacityForecast
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapacityForecast> {
    private static final SdkField<List<Instant>> TIMESTAMPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Timestamps").getter(CapacityForecast.getter(CapacityForecast::timestamps)).setter(CapacityForecast.setter(Builder::timestamps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INSTANT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Double>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Values").getter(CapacityForecast.getter(CapacityForecast::values)).setter(CapacityForecast.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMPS_FIELD, VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CapacityForecast.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Instant> timestamps;
    private final List<Double> values;

    private CapacityForecast(BuilderImpl builder) {
        this.timestamps = builder.timestamps;
        this.values = builder.values;
    }

    public final boolean hasTimestamps() {
        return this.timestamps != null && !(this.timestamps instanceof SdkAutoConstructList);
    }

    public final List<Instant> timestamps() {
        return this.timestamps;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<Double> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTimestamps() ? this.timestamps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityForecast)) {
            return false;
        }
        CapacityForecast other = (CapacityForecast)obj;
        return this.hasTimestamps() == other.hasTimestamps() && Objects.equals(this.timestamps(), other.timestamps()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values());
    }

    public final String toString() {
        return ToString.builder((String)"CapacityForecast").add("Timestamps", this.hasTimestamps() ? this.timestamps() : null).add("Values", this.hasValues() ? this.values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Timestamps": {
                return Optional.ofNullable(clazz.cast(this.timestamps()));
            }
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Timestamps", TIMESTAMPS_FIELD);
        map.put("Values", VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityForecast, T> g) {
        return obj -> g.apply((CapacityForecast)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Instant> timestamps = DefaultSdkAutoConstructList.getInstance();
        private List<Double> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityForecast model) {
            this.timestamps(model.timestamps);
            this.values(model.values);
        }

        public final Collection<Instant> getTimestamps() {
            if (this.timestamps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.timestamps;
        }

        public final void setTimestamps(Collection<Instant> timestamps) {
            this.timestamps = PredictiveScalingForecastTimestampsCopier.copy(timestamps);
        }

        @Override
        public final Builder timestamps(Collection<Instant> timestamps) {
            this.timestamps = PredictiveScalingForecastTimestampsCopier.copy(timestamps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timestamps(Instant ... timestamps) {
            this.timestamps(Arrays.asList(timestamps));
            return this;
        }

        public final Collection<Double> getValues() {
            if (this.values instanceof SdkAutoConstructList) {
                return null;
            }
            return this.values;
        }

        public final void setValues(Collection<Double> values) {
            this.values = PredictiveScalingForecastValuesCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<Double> values) {
            this.values = PredictiveScalingForecastValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Double ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public CapacityForecast build() {
            return new CapacityForecast(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapacityForecast> {
        public Builder timestamps(Collection<Instant> var1);

        public Builder timestamps(Instant ... var1);

        public Builder values(Collection<Double> var1);

        public Builder values(Double ... var1);
    }
}

