/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingResponse;
import software.amazon.awssdk.services.autoscaling.model.ScheduledUpdateGroupAction;
import software.amazon.awssdk.services.autoscaling.model.ScheduledUpdateGroupActionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeScheduledActionsResponse
extends AutoScalingResponse
implements ToCopyableBuilder<Builder, DescribeScheduledActionsResponse> {
    private static final SdkField<List<ScheduledUpdateGroupAction>> SCHEDULED_UPDATE_GROUP_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScheduledUpdateGroupActions").getter(DescribeScheduledActionsResponse.getter(DescribeScheduledActionsResponse::scheduledUpdateGroupActions)).setter(DescribeScheduledActionsResponse.setter(Builder::scheduledUpdateGroupActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledUpdateGroupActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScheduledUpdateGroupAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeScheduledActionsResponse.getter(DescribeScheduledActionsResponse::nextToken)).setter(DescribeScheduledActionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_UPDATE_GROUP_ACTIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeScheduledActionsResponse.memberNameToFieldInitializer();
    private final List<ScheduledUpdateGroupAction> scheduledUpdateGroupActions;
    private final String nextToken;

    private DescribeScheduledActionsResponse(BuilderImpl builder) {
        super(builder);
        this.scheduledUpdateGroupActions = builder.scheduledUpdateGroupActions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasScheduledUpdateGroupActions() {
        return this.scheduledUpdateGroupActions != null && !(this.scheduledUpdateGroupActions instanceof SdkAutoConstructList);
    }

    public final List<ScheduledUpdateGroupAction> scheduledUpdateGroupActions() {
        return this.scheduledUpdateGroupActions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScheduledUpdateGroupActions() ? this.scheduledUpdateGroupActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledActionsResponse)) {
            return false;
        }
        DescribeScheduledActionsResponse other = (DescribeScheduledActionsResponse)((Object)obj);
        return this.hasScheduledUpdateGroupActions() == other.hasScheduledUpdateGroupActions() && Objects.equals(this.scheduledUpdateGroupActions(), other.scheduledUpdateGroupActions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeScheduledActionsResponse").add("ScheduledUpdateGroupActions", this.hasScheduledUpdateGroupActions() ? this.scheduledUpdateGroupActions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScheduledUpdateGroupActions": {
                return Optional.ofNullable(clazz.cast(this.scheduledUpdateGroupActions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ScheduledUpdateGroupActions", SCHEDULED_UPDATE_GROUP_ACTIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeScheduledActionsResponse, T> g) {
        return obj -> g.apply((DescribeScheduledActionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingResponse.BuilderImpl
    implements Builder {
        private List<ScheduledUpdateGroupAction> scheduledUpdateGroupActions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledActionsResponse model) {
            super(model);
            this.scheduledUpdateGroupActions(model.scheduledUpdateGroupActions);
            this.nextToken(model.nextToken);
        }

        public final List<ScheduledUpdateGroupAction.Builder> getScheduledUpdateGroupActions() {
            List<ScheduledUpdateGroupAction.Builder> result = ScheduledUpdateGroupActionsCopier.copyToBuilder(this.scheduledUpdateGroupActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScheduledUpdateGroupActions(Collection<ScheduledUpdateGroupAction.BuilderImpl> scheduledUpdateGroupActions) {
            this.scheduledUpdateGroupActions = ScheduledUpdateGroupActionsCopier.copyFromBuilder(scheduledUpdateGroupActions);
        }

        @Override
        public final Builder scheduledUpdateGroupActions(Collection<ScheduledUpdateGroupAction> scheduledUpdateGroupActions) {
            this.scheduledUpdateGroupActions = ScheduledUpdateGroupActionsCopier.copy(scheduledUpdateGroupActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledUpdateGroupActions(ScheduledUpdateGroupAction ... scheduledUpdateGroupActions) {
            this.scheduledUpdateGroupActions(Arrays.asList(scheduledUpdateGroupActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledUpdateGroupActions(Consumer<ScheduledUpdateGroupAction.Builder> ... scheduledUpdateGroupActions) {
            this.scheduledUpdateGroupActions(Stream.of(scheduledUpdateGroupActions).map(c -> (ScheduledUpdateGroupAction)((ScheduledUpdateGroupAction.Builder)ScheduledUpdateGroupAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeScheduledActionsResponse build() {
            return new DescribeScheduledActionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AutoScalingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeScheduledActionsResponse> {
        public Builder scheduledUpdateGroupActions(Collection<ScheduledUpdateGroupAction> var1);

        public Builder scheduledUpdateGroupActions(ScheduledUpdateGroupAction ... var1);

        public Builder scheduledUpdateGroupActions(Consumer<ScheduledUpdateGroupAction.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

