/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.PredictiveScalingMaxCapacityBreachBehavior;
import software.amazon.awssdk.services.autoscaling.model.PredictiveScalingMetricSpecification;
import software.amazon.awssdk.services.autoscaling.model.PredictiveScalingMetricSpecificationsCopier;
import software.amazon.awssdk.services.autoscaling.model.PredictiveScalingMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PredictiveScalingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PredictiveScalingConfiguration> {
    private static final SdkField<List<PredictiveScalingMetricSpecification>> METRIC_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricSpecifications").getter(PredictiveScalingConfiguration.getter(PredictiveScalingConfiguration::metricSpecifications)).setter(PredictiveScalingConfiguration.setter(Builder::metricSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSpecifications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PredictiveScalingMetricSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(PredictiveScalingConfiguration.getter(PredictiveScalingConfiguration::modeAsString)).setter(PredictiveScalingConfiguration.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final SdkField<Integer> SCHEDULING_BUFFER_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SchedulingBufferTime").getter(PredictiveScalingConfiguration.getter(PredictiveScalingConfiguration::schedulingBufferTime)).setter(PredictiveScalingConfiguration.setter(Builder::schedulingBufferTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchedulingBufferTime").build()}).build();
    private static final SdkField<String> MAX_CAPACITY_BREACH_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxCapacityBreachBehavior").getter(PredictiveScalingConfiguration.getter(PredictiveScalingConfiguration::maxCapacityBreachBehaviorAsString)).setter(PredictiveScalingConfiguration.setter(Builder::maxCapacityBreachBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacityBreachBehavior").build()}).build();
    private static final SdkField<Integer> MAX_CAPACITY_BUFFER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxCapacityBuffer").getter(PredictiveScalingConfiguration.getter(PredictiveScalingConfiguration::maxCapacityBuffer)).setter(PredictiveScalingConfiguration.setter(Builder::maxCapacityBuffer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacityBuffer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_SPECIFICATIONS_FIELD, MODE_FIELD, SCHEDULING_BUFFER_TIME_FIELD, MAX_CAPACITY_BREACH_BEHAVIOR_FIELD, MAX_CAPACITY_BUFFER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PredictiveScalingConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<PredictiveScalingMetricSpecification> metricSpecifications;
    private final String mode;
    private final Integer schedulingBufferTime;
    private final String maxCapacityBreachBehavior;
    private final Integer maxCapacityBuffer;

    private PredictiveScalingConfiguration(BuilderImpl builder) {
        this.metricSpecifications = builder.metricSpecifications;
        this.mode = builder.mode;
        this.schedulingBufferTime = builder.schedulingBufferTime;
        this.maxCapacityBreachBehavior = builder.maxCapacityBreachBehavior;
        this.maxCapacityBuffer = builder.maxCapacityBuffer;
    }

    public final boolean hasMetricSpecifications() {
        return this.metricSpecifications != null && !(this.metricSpecifications instanceof SdkAutoConstructList);
    }

    public final List<PredictiveScalingMetricSpecification> metricSpecifications() {
        return this.metricSpecifications;
    }

    public final PredictiveScalingMode mode() {
        return PredictiveScalingMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final Integer schedulingBufferTime() {
        return this.schedulingBufferTime;
    }

    public final PredictiveScalingMaxCapacityBreachBehavior maxCapacityBreachBehavior() {
        return PredictiveScalingMaxCapacityBreachBehavior.fromValue(this.maxCapacityBreachBehavior);
    }

    public final String maxCapacityBreachBehaviorAsString() {
        return this.maxCapacityBreachBehavior;
    }

    public final Integer maxCapacityBuffer() {
        return this.maxCapacityBuffer;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricSpecifications() ? this.metricSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedulingBufferTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCapacityBreachBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCapacityBuffer());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictiveScalingConfiguration)) {
            return false;
        }
        PredictiveScalingConfiguration other = (PredictiveScalingConfiguration)obj;
        return this.hasMetricSpecifications() == other.hasMetricSpecifications() && Objects.equals(this.metricSpecifications(), other.metricSpecifications()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.schedulingBufferTime(), other.schedulingBufferTime()) && Objects.equals(this.maxCapacityBreachBehaviorAsString(), other.maxCapacityBreachBehaviorAsString()) && Objects.equals(this.maxCapacityBuffer(), other.maxCapacityBuffer());
    }

    public final String toString() {
        return ToString.builder((String)"PredictiveScalingConfiguration").add("MetricSpecifications", this.hasMetricSpecifications() ? this.metricSpecifications() : null).add("Mode", (Object)this.modeAsString()).add("SchedulingBufferTime", (Object)this.schedulingBufferTime()).add("MaxCapacityBreachBehavior", (Object)this.maxCapacityBreachBehaviorAsString()).add("MaxCapacityBuffer", (Object)this.maxCapacityBuffer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricSpecifications": {
                return Optional.ofNullable(clazz.cast(this.metricSpecifications()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "SchedulingBufferTime": {
                return Optional.ofNullable(clazz.cast(this.schedulingBufferTime()));
            }
            case "MaxCapacityBreachBehavior": {
                return Optional.ofNullable(clazz.cast(this.maxCapacityBreachBehaviorAsString()));
            }
            case "MaxCapacityBuffer": {
                return Optional.ofNullable(clazz.cast(this.maxCapacityBuffer()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MetricSpecifications", METRIC_SPECIFICATIONS_FIELD);
        map.put("Mode", MODE_FIELD);
        map.put("SchedulingBufferTime", SCHEDULING_BUFFER_TIME_FIELD);
        map.put("MaxCapacityBreachBehavior", MAX_CAPACITY_BREACH_BEHAVIOR_FIELD);
        map.put("MaxCapacityBuffer", MAX_CAPACITY_BUFFER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PredictiveScalingConfiguration, T> g) {
        return obj -> g.apply((PredictiveScalingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<PredictiveScalingMetricSpecification> metricSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String mode;
        private Integer schedulingBufferTime;
        private String maxCapacityBreachBehavior;
        private Integer maxCapacityBuffer;

        private BuilderImpl() {
        }

        private BuilderImpl(PredictiveScalingConfiguration model) {
            this.metricSpecifications(model.metricSpecifications);
            this.mode(model.mode);
            this.schedulingBufferTime(model.schedulingBufferTime);
            this.maxCapacityBreachBehavior(model.maxCapacityBreachBehavior);
            this.maxCapacityBuffer(model.maxCapacityBuffer);
        }

        public final List<PredictiveScalingMetricSpecification.Builder> getMetricSpecifications() {
            List<PredictiveScalingMetricSpecification.Builder> result = PredictiveScalingMetricSpecificationsCopier.copyToBuilder(this.metricSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricSpecifications(Collection<PredictiveScalingMetricSpecification.BuilderImpl> metricSpecifications) {
            this.metricSpecifications = PredictiveScalingMetricSpecificationsCopier.copyFromBuilder(metricSpecifications);
        }

        @Override
        public final Builder metricSpecifications(Collection<PredictiveScalingMetricSpecification> metricSpecifications) {
            this.metricSpecifications = PredictiveScalingMetricSpecificationsCopier.copy(metricSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricSpecifications(PredictiveScalingMetricSpecification ... metricSpecifications) {
            this.metricSpecifications(Arrays.asList(metricSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricSpecifications(Consumer<PredictiveScalingMetricSpecification.Builder> ... metricSpecifications) {
            this.metricSpecifications(Stream.of(metricSpecifications).map(c -> (PredictiveScalingMetricSpecification)((PredictiveScalingMetricSpecification.Builder)PredictiveScalingMetricSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(PredictiveScalingMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final Integer getSchedulingBufferTime() {
            return this.schedulingBufferTime;
        }

        public final void setSchedulingBufferTime(Integer schedulingBufferTime) {
            this.schedulingBufferTime = schedulingBufferTime;
        }

        @Override
        public final Builder schedulingBufferTime(Integer schedulingBufferTime) {
            this.schedulingBufferTime = schedulingBufferTime;
            return this;
        }

        public final String getMaxCapacityBreachBehavior() {
            return this.maxCapacityBreachBehavior;
        }

        public final void setMaxCapacityBreachBehavior(String maxCapacityBreachBehavior) {
            this.maxCapacityBreachBehavior = maxCapacityBreachBehavior;
        }

        @Override
        public final Builder maxCapacityBreachBehavior(String maxCapacityBreachBehavior) {
            this.maxCapacityBreachBehavior = maxCapacityBreachBehavior;
            return this;
        }

        @Override
        public final Builder maxCapacityBreachBehavior(PredictiveScalingMaxCapacityBreachBehavior maxCapacityBreachBehavior) {
            this.maxCapacityBreachBehavior(maxCapacityBreachBehavior == null ? null : maxCapacityBreachBehavior.toString());
            return this;
        }

        public final Integer getMaxCapacityBuffer() {
            return this.maxCapacityBuffer;
        }

        public final void setMaxCapacityBuffer(Integer maxCapacityBuffer) {
            this.maxCapacityBuffer = maxCapacityBuffer;
        }

        @Override
        public final Builder maxCapacityBuffer(Integer maxCapacityBuffer) {
            this.maxCapacityBuffer = maxCapacityBuffer;
            return this;
        }

        public PredictiveScalingConfiguration build() {
            return new PredictiveScalingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PredictiveScalingConfiguration> {
        public Builder metricSpecifications(Collection<PredictiveScalingMetricSpecification> var1);

        public Builder metricSpecifications(PredictiveScalingMetricSpecification ... var1);

        public Builder metricSpecifications(Consumer<PredictiveScalingMetricSpecification.Builder> ... var1);

        public Builder mode(String var1);

        public Builder mode(PredictiveScalingMode var1);

        public Builder schedulingBufferTime(Integer var1);

        public Builder maxCapacityBreachBehavior(String var1);

        public Builder maxCapacityBreachBehavior(PredictiveScalingMaxCapacityBreachBehavior var1);

        public Builder maxCapacityBuffer(Integer var1);
    }
}

