/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.autoscaling.model.ImpairedZoneHealthCheckBehavior;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AvailabilityZoneImpairmentPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AvailabilityZoneImpairmentPolicy> {
    private static final SdkField<Boolean> ZONAL_SHIFT_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ZonalShiftEnabled").getter(AvailabilityZoneImpairmentPolicy.getter(AvailabilityZoneImpairmentPolicy::zonalShiftEnabled)).setter(AvailabilityZoneImpairmentPolicy.setter(Builder::zonalShiftEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZonalShiftEnabled").build()}).build();
    private static final SdkField<String> IMPAIRED_ZONE_HEALTH_CHECK_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImpairedZoneHealthCheckBehavior").getter(AvailabilityZoneImpairmentPolicy.getter(AvailabilityZoneImpairmentPolicy::impairedZoneHealthCheckBehaviorAsString)).setter(AvailabilityZoneImpairmentPolicy.setter(Builder::impairedZoneHealthCheckBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImpairedZoneHealthCheckBehavior").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ZONAL_SHIFT_ENABLED_FIELD, IMPAIRED_ZONE_HEALTH_CHECK_BEHAVIOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ZonalShiftEnabled", ZONAL_SHIFT_ENABLED_FIELD);
            this.put("ImpairedZoneHealthCheckBehavior", IMPAIRED_ZONE_HEALTH_CHECK_BEHAVIOR_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Boolean zonalShiftEnabled;
    private final String impairedZoneHealthCheckBehavior;

    private AvailabilityZoneImpairmentPolicy(BuilderImpl builder) {
        this.zonalShiftEnabled = builder.zonalShiftEnabled;
        this.impairedZoneHealthCheckBehavior = builder.impairedZoneHealthCheckBehavior;
    }

    public final Boolean zonalShiftEnabled() {
        return this.zonalShiftEnabled;
    }

    public final ImpairedZoneHealthCheckBehavior impairedZoneHealthCheckBehavior() {
        return ImpairedZoneHealthCheckBehavior.fromValue(this.impairedZoneHealthCheckBehavior);
    }

    public final String impairedZoneHealthCheckBehaviorAsString() {
        return this.impairedZoneHealthCheckBehavior;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.zonalShiftEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.impairedZoneHealthCheckBehaviorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailabilityZoneImpairmentPolicy)) {
            return false;
        }
        AvailabilityZoneImpairmentPolicy other = (AvailabilityZoneImpairmentPolicy)obj;
        return Objects.equals(this.zonalShiftEnabled(), other.zonalShiftEnabled()) && Objects.equals(this.impairedZoneHealthCheckBehaviorAsString(), other.impairedZoneHealthCheckBehaviorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AvailabilityZoneImpairmentPolicy").add("ZonalShiftEnabled", (Object)this.zonalShiftEnabled()).add("ImpairedZoneHealthCheckBehavior", (Object)this.impairedZoneHealthCheckBehaviorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ZonalShiftEnabled": {
                return Optional.ofNullable(clazz.cast(this.zonalShiftEnabled()));
            }
            case "ImpairedZoneHealthCheckBehavior": {
                return Optional.ofNullable(clazz.cast(this.impairedZoneHealthCheckBehaviorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AvailabilityZoneImpairmentPolicy, T> g) {
        return obj -> g.apply((AvailabilityZoneImpairmentPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean zonalShiftEnabled;
        private String impairedZoneHealthCheckBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailabilityZoneImpairmentPolicy model) {
            this.zonalShiftEnabled(model.zonalShiftEnabled);
            this.impairedZoneHealthCheckBehavior(model.impairedZoneHealthCheckBehavior);
        }

        public final Boolean getZonalShiftEnabled() {
            return this.zonalShiftEnabled;
        }

        public final void setZonalShiftEnabled(Boolean zonalShiftEnabled) {
            this.zonalShiftEnabled = zonalShiftEnabled;
        }

        @Override
        public final Builder zonalShiftEnabled(Boolean zonalShiftEnabled) {
            this.zonalShiftEnabled = zonalShiftEnabled;
            return this;
        }

        public final String getImpairedZoneHealthCheckBehavior() {
            return this.impairedZoneHealthCheckBehavior;
        }

        public final void setImpairedZoneHealthCheckBehavior(String impairedZoneHealthCheckBehavior) {
            this.impairedZoneHealthCheckBehavior = impairedZoneHealthCheckBehavior;
        }

        @Override
        public final Builder impairedZoneHealthCheckBehavior(String impairedZoneHealthCheckBehavior) {
            this.impairedZoneHealthCheckBehavior = impairedZoneHealthCheckBehavior;
            return this;
        }

        @Override
        public final Builder impairedZoneHealthCheckBehavior(ImpairedZoneHealthCheckBehavior impairedZoneHealthCheckBehavior) {
            this.impairedZoneHealthCheckBehavior(impairedZoneHealthCheckBehavior == null ? null : impairedZoneHealthCheckBehavior.toString());
            return this;
        }

        public AvailabilityZoneImpairmentPolicy build() {
            return new AvailabilityZoneImpairmentPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AvailabilityZoneImpairmentPolicy> {
        public Builder zonalShiftEnabled(Boolean var1);

        public Builder impairedZoneHealthCheckBehavior(String var1);

        public Builder impairedZoneHealthCheckBehavior(ImpairedZoneHealthCheckBehavior var1);
    }
}

