/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceMaintenancePolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceMaintenancePolicy> {
    private static final SdkField<Integer> MIN_HEALTHY_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinHealthyPercentage").getter(InstanceMaintenancePolicy.getter(InstanceMaintenancePolicy::minHealthyPercentage)).setter(InstanceMaintenancePolicy.setter(Builder::minHealthyPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinHealthyPercentage").build()}).build();
    private static final SdkField<Integer> MAX_HEALTHY_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxHealthyPercentage").getter(InstanceMaintenancePolicy.getter(InstanceMaintenancePolicy::maxHealthyPercentage)).setter(InstanceMaintenancePolicy.setter(Builder::maxHealthyPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxHealthyPercentage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_HEALTHY_PERCENTAGE_FIELD, MAX_HEALTHY_PERCENTAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MinHealthyPercentage", MIN_HEALTHY_PERCENTAGE_FIELD);
            this.put("MaxHealthyPercentage", MAX_HEALTHY_PERCENTAGE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer minHealthyPercentage;
    private final Integer maxHealthyPercentage;

    private InstanceMaintenancePolicy(BuilderImpl builder) {
        this.minHealthyPercentage = builder.minHealthyPercentage;
        this.maxHealthyPercentage = builder.maxHealthyPercentage;
    }

    public final Integer minHealthyPercentage() {
        return this.minHealthyPercentage;
    }

    public final Integer maxHealthyPercentage() {
        return this.maxHealthyPercentage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minHealthyPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxHealthyPercentage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceMaintenancePolicy)) {
            return false;
        }
        InstanceMaintenancePolicy other = (InstanceMaintenancePolicy)obj;
        return Objects.equals(this.minHealthyPercentage(), other.minHealthyPercentage()) && Objects.equals(this.maxHealthyPercentage(), other.maxHealthyPercentage());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceMaintenancePolicy").add("MinHealthyPercentage", (Object)this.minHealthyPercentage()).add("MaxHealthyPercentage", (Object)this.maxHealthyPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MinHealthyPercentage": {
                return Optional.ofNullable(clazz.cast(this.minHealthyPercentage()));
            }
            case "MaxHealthyPercentage": {
                return Optional.ofNullable(clazz.cast(this.maxHealthyPercentage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InstanceMaintenancePolicy, T> g) {
        return obj -> g.apply((InstanceMaintenancePolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer minHealthyPercentage;
        private Integer maxHealthyPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceMaintenancePolicy model) {
            this.minHealthyPercentage(model.minHealthyPercentage);
            this.maxHealthyPercentage(model.maxHealthyPercentage);
        }

        public final Integer getMinHealthyPercentage() {
            return this.minHealthyPercentage;
        }

        public final void setMinHealthyPercentage(Integer minHealthyPercentage) {
            this.minHealthyPercentage = minHealthyPercentage;
        }

        @Override
        public final Builder minHealthyPercentage(Integer minHealthyPercentage) {
            this.minHealthyPercentage = minHealthyPercentage;
            return this;
        }

        public final Integer getMaxHealthyPercentage() {
            return this.maxHealthyPercentage;
        }

        public final void setMaxHealthyPercentage(Integer maxHealthyPercentage) {
            this.maxHealthyPercentage = maxHealthyPercentage;
        }

        @Override
        public final Builder maxHealthyPercentage(Integer maxHealthyPercentage) {
            this.maxHealthyPercentage = maxHealthyPercentage;
            return this;
        }

        public InstanceMaintenancePolicy build() {
            return new InstanceMaintenancePolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceMaintenancePolicy> {
        public Builder minHealthyPercentage(Integer var1);

        public Builder maxHealthyPercentage(Integer var1);
    }
}

