/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.autoscaling.AutoScalingAsyncClient;
import software.amazon.awssdk.services.autoscaling.internal.UserAgentUtils;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersResponse;

public class DescribeLoadBalancersPublisher
implements SdkPublisher<DescribeLoadBalancersResponse> {
    private final AutoScalingAsyncClient client;
    private final DescribeLoadBalancersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeLoadBalancersPublisher(AutoScalingAsyncClient client, DescribeLoadBalancersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeLoadBalancersPublisher(AutoScalingAsyncClient client, DescribeLoadBalancersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeLoadBalancersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeLoadBalancersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeLoadBalancersResponseFetcher
    implements AsyncPageFetcher<DescribeLoadBalancersResponse> {
        private DescribeLoadBalancersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLoadBalancersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeLoadBalancersResponse> nextPage(DescribeLoadBalancersResponse previousPage) {
            if (previousPage == null) {
                return DescribeLoadBalancersPublisher.this.client.describeLoadBalancers(DescribeLoadBalancersPublisher.this.firstRequest);
            }
            return DescribeLoadBalancersPublisher.this.client.describeLoadBalancers((DescribeLoadBalancersRequest)((Object)DescribeLoadBalancersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

