/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.autoscaling.AutoScalingClient;
import software.amazon.awssdk.services.autoscaling.internal.UserAgentUtils;
import software.amazon.awssdk.services.autoscaling.model.DescribeWarmPoolRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeWarmPoolResponse;
import software.amazon.awssdk.services.autoscaling.model.Instance;

public class DescribeWarmPoolIterable
implements SdkIterable<DescribeWarmPoolResponse> {
    private final AutoScalingClient client;
    private final DescribeWarmPoolRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeWarmPoolIterable(AutoScalingClient client, DescribeWarmPoolRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeWarmPoolResponseFetcher();
    }

    public Iterator<DescribeWarmPoolResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Instance> instances() {
        Function<DescribeWarmPoolResponse, Iterator> getIterator = response -> {
            if (response != null && response.instances() != null) {
                return response.instances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeWarmPoolResponseFetcher
    implements SyncPageFetcher<DescribeWarmPoolResponse> {
        private DescribeWarmPoolResponseFetcher() {
        }

        public boolean hasNextPage(DescribeWarmPoolResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeWarmPoolResponse nextPage(DescribeWarmPoolResponse previousPage) {
            if (previousPage == null) {
                return DescribeWarmPoolIterable.this.client.describeWarmPool(DescribeWarmPoolIterable.this.firstRequest);
            }
            return DescribeWarmPoolIterable.this.client.describeWarmPool((DescribeWarmPoolRequest)((Object)DescribeWarmPoolIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

