/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.autoscaling.AutoScalingClient;
import software.amazon.awssdk.services.autoscaling.internal.UserAgentUtils;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersResponse;

public class DescribeLoadBalancersIterable
implements SdkIterable<DescribeLoadBalancersResponse> {
    private final AutoScalingClient client;
    private final DescribeLoadBalancersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeLoadBalancersIterable(AutoScalingClient client, DescribeLoadBalancersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeLoadBalancersResponseFetcher();
    }

    public Iterator<DescribeLoadBalancersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeLoadBalancersResponseFetcher
    implements SyncPageFetcher<DescribeLoadBalancersResponse> {
        private DescribeLoadBalancersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLoadBalancersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeLoadBalancersResponse nextPage(DescribeLoadBalancersResponse previousPage) {
            if (previousPage == null) {
                return DescribeLoadBalancersIterable.this.client.describeLoadBalancers(DescribeLoadBalancersIterable.this.firstRequest);
            }
            return DescribeLoadBalancersIterable.this.client.describeLoadBalancers((DescribeLoadBalancersRequest)((Object)DescribeLoadBalancersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

