/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AlarmSpecification;
import software.amazon.awssdk.services.autoscaling.model.CheckpointPercentagesCopier;
import software.amazon.awssdk.services.autoscaling.model.ScaleInProtectedInstances;
import software.amazon.awssdk.services.autoscaling.model.StandbyInstances;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RefreshPreferences
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RefreshPreferences> {
    private static final SdkField<Integer> MIN_HEALTHY_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinHealthyPercentage").getter(RefreshPreferences.getter(RefreshPreferences::minHealthyPercentage)).setter(RefreshPreferences.setter(Builder::minHealthyPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinHealthyPercentage").build()}).build();
    private static final SdkField<Integer> INSTANCE_WARMUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceWarmup").getter(RefreshPreferences.getter(RefreshPreferences::instanceWarmup)).setter(RefreshPreferences.setter(Builder::instanceWarmup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceWarmup").build()}).build();
    private static final SdkField<List<Integer>> CHECKPOINT_PERCENTAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CheckpointPercentages").getter(RefreshPreferences.getter(RefreshPreferences::checkpointPercentages)).setter(RefreshPreferences.setter(Builder::checkpointPercentages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckpointPercentages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> CHECKPOINT_DELAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CheckpointDelay").getter(RefreshPreferences.getter(RefreshPreferences::checkpointDelay)).setter(RefreshPreferences.setter(Builder::checkpointDelay)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckpointDelay").build()}).build();
    private static final SdkField<Boolean> SKIP_MATCHING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SkipMatching").getter(RefreshPreferences.getter(RefreshPreferences::skipMatching)).setter(RefreshPreferences.setter(Builder::skipMatching)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkipMatching").build()}).build();
    private static final SdkField<Boolean> AUTO_ROLLBACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoRollback").getter(RefreshPreferences.getter(RefreshPreferences::autoRollback)).setter(RefreshPreferences.setter(Builder::autoRollback)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoRollback").build()}).build();
    private static final SdkField<String> SCALE_IN_PROTECTED_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScaleInProtectedInstances").getter(RefreshPreferences.getter(RefreshPreferences::scaleInProtectedInstancesAsString)).setter(RefreshPreferences.setter(Builder::scaleInProtectedInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScaleInProtectedInstances").build()}).build();
    private static final SdkField<String> STANDBY_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StandbyInstances").getter(RefreshPreferences.getter(RefreshPreferences::standbyInstancesAsString)).setter(RefreshPreferences.setter(Builder::standbyInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandbyInstances").build()}).build();
    private static final SdkField<AlarmSpecification> ALARM_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AlarmSpecification").getter(RefreshPreferences.getter(RefreshPreferences::alarmSpecification)).setter(RefreshPreferences.setter(Builder::alarmSpecification)).constructor(AlarmSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmSpecification").build()}).build();
    private static final SdkField<Integer> MAX_HEALTHY_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxHealthyPercentage").getter(RefreshPreferences.getter(RefreshPreferences::maxHealthyPercentage)).setter(RefreshPreferences.setter(Builder::maxHealthyPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxHealthyPercentage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_HEALTHY_PERCENTAGE_FIELD, INSTANCE_WARMUP_FIELD, CHECKPOINT_PERCENTAGES_FIELD, CHECKPOINT_DELAY_FIELD, SKIP_MATCHING_FIELD, AUTO_ROLLBACK_FIELD, SCALE_IN_PROTECTED_INSTANCES_FIELD, STANDBY_INSTANCES_FIELD, ALARM_SPECIFICATION_FIELD, MAX_HEALTHY_PERCENTAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer minHealthyPercentage;
    private final Integer instanceWarmup;
    private final List<Integer> checkpointPercentages;
    private final Integer checkpointDelay;
    private final Boolean skipMatching;
    private final Boolean autoRollback;
    private final String scaleInProtectedInstances;
    private final String standbyInstances;
    private final AlarmSpecification alarmSpecification;
    private final Integer maxHealthyPercentage;

    private RefreshPreferences(BuilderImpl builder) {
        this.minHealthyPercentage = builder.minHealthyPercentage;
        this.instanceWarmup = builder.instanceWarmup;
        this.checkpointPercentages = builder.checkpointPercentages;
        this.checkpointDelay = builder.checkpointDelay;
        this.skipMatching = builder.skipMatching;
        this.autoRollback = builder.autoRollback;
        this.scaleInProtectedInstances = builder.scaleInProtectedInstances;
        this.standbyInstances = builder.standbyInstances;
        this.alarmSpecification = builder.alarmSpecification;
        this.maxHealthyPercentage = builder.maxHealthyPercentage;
    }

    public final Integer minHealthyPercentage() {
        return this.minHealthyPercentage;
    }

    public final Integer instanceWarmup() {
        return this.instanceWarmup;
    }

    public final boolean hasCheckpointPercentages() {
        return this.checkpointPercentages != null && !(this.checkpointPercentages instanceof SdkAutoConstructList);
    }

    public final List<Integer> checkpointPercentages() {
        return this.checkpointPercentages;
    }

    public final Integer checkpointDelay() {
        return this.checkpointDelay;
    }

    public final Boolean skipMatching() {
        return this.skipMatching;
    }

    public final Boolean autoRollback() {
        return this.autoRollback;
    }

    public final ScaleInProtectedInstances scaleInProtectedInstances() {
        return ScaleInProtectedInstances.fromValue(this.scaleInProtectedInstances);
    }

    public final String scaleInProtectedInstancesAsString() {
        return this.scaleInProtectedInstances;
    }

    public final StandbyInstances standbyInstances() {
        return StandbyInstances.fromValue(this.standbyInstances);
    }

    public final String standbyInstancesAsString() {
        return this.standbyInstances;
    }

    public final AlarmSpecification alarmSpecification() {
        return this.alarmSpecification;
    }

    public final Integer maxHealthyPercentage() {
        return this.maxHealthyPercentage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minHealthyPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceWarmup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCheckpointPercentages() ? this.checkpointPercentages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.checkpointDelay());
        hashCode = 31 * hashCode + Objects.hashCode(this.skipMatching());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRollback());
        hashCode = 31 * hashCode + Objects.hashCode(this.scaleInProtectedInstancesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.standbyInstancesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxHealthyPercentage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefreshPreferences)) {
            return false;
        }
        RefreshPreferences other = (RefreshPreferences)obj;
        return Objects.equals(this.minHealthyPercentage(), other.minHealthyPercentage()) && Objects.equals(this.instanceWarmup(), other.instanceWarmup()) && this.hasCheckpointPercentages() == other.hasCheckpointPercentages() && Objects.equals(this.checkpointPercentages(), other.checkpointPercentages()) && Objects.equals(this.checkpointDelay(), other.checkpointDelay()) && Objects.equals(this.skipMatching(), other.skipMatching()) && Objects.equals(this.autoRollback(), other.autoRollback()) && Objects.equals(this.scaleInProtectedInstancesAsString(), other.scaleInProtectedInstancesAsString()) && Objects.equals(this.standbyInstancesAsString(), other.standbyInstancesAsString()) && Objects.equals(this.alarmSpecification(), other.alarmSpecification()) && Objects.equals(this.maxHealthyPercentage(), other.maxHealthyPercentage());
    }

    public final String toString() {
        return ToString.builder((String)"RefreshPreferences").add("MinHealthyPercentage", (Object)this.minHealthyPercentage()).add("InstanceWarmup", (Object)this.instanceWarmup()).add("CheckpointPercentages", this.hasCheckpointPercentages() ? this.checkpointPercentages() : null).add("CheckpointDelay", (Object)this.checkpointDelay()).add("SkipMatching", (Object)this.skipMatching()).add("AutoRollback", (Object)this.autoRollback()).add("ScaleInProtectedInstances", (Object)this.scaleInProtectedInstancesAsString()).add("StandbyInstances", (Object)this.standbyInstancesAsString()).add("AlarmSpecification", (Object)this.alarmSpecification()).add("MaxHealthyPercentage", (Object)this.maxHealthyPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MinHealthyPercentage": {
                return Optional.ofNullable(clazz.cast(this.minHealthyPercentage()));
            }
            case "InstanceWarmup": {
                return Optional.ofNullable(clazz.cast(this.instanceWarmup()));
            }
            case "CheckpointPercentages": {
                return Optional.ofNullable(clazz.cast(this.checkpointPercentages()));
            }
            case "CheckpointDelay": {
                return Optional.ofNullable(clazz.cast(this.checkpointDelay()));
            }
            case "SkipMatching": {
                return Optional.ofNullable(clazz.cast(this.skipMatching()));
            }
            case "AutoRollback": {
                return Optional.ofNullable(clazz.cast(this.autoRollback()));
            }
            case "ScaleInProtectedInstances": {
                return Optional.ofNullable(clazz.cast(this.scaleInProtectedInstancesAsString()));
            }
            case "StandbyInstances": {
                return Optional.ofNullable(clazz.cast(this.standbyInstancesAsString()));
            }
            case "AlarmSpecification": {
                return Optional.ofNullable(clazz.cast(this.alarmSpecification()));
            }
            case "MaxHealthyPercentage": {
                return Optional.ofNullable(clazz.cast(this.maxHealthyPercentage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RefreshPreferences, T> g) {
        return obj -> g.apply((RefreshPreferences)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer minHealthyPercentage;
        private Integer instanceWarmup;
        private List<Integer> checkpointPercentages = DefaultSdkAutoConstructList.getInstance();
        private Integer checkpointDelay;
        private Boolean skipMatching;
        private Boolean autoRollback;
        private String scaleInProtectedInstances;
        private String standbyInstances;
        private AlarmSpecification alarmSpecification;
        private Integer maxHealthyPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(RefreshPreferences model) {
            this.minHealthyPercentage(model.minHealthyPercentage);
            this.instanceWarmup(model.instanceWarmup);
            this.checkpointPercentages(model.checkpointPercentages);
            this.checkpointDelay(model.checkpointDelay);
            this.skipMatching(model.skipMatching);
            this.autoRollback(model.autoRollback);
            this.scaleInProtectedInstances(model.scaleInProtectedInstances);
            this.standbyInstances(model.standbyInstances);
            this.alarmSpecification(model.alarmSpecification);
            this.maxHealthyPercentage(model.maxHealthyPercentage);
        }

        public final Integer getMinHealthyPercentage() {
            return this.minHealthyPercentage;
        }

        public final void setMinHealthyPercentage(Integer minHealthyPercentage) {
            this.minHealthyPercentage = minHealthyPercentage;
        }

        @Override
        public final Builder minHealthyPercentage(Integer minHealthyPercentage) {
            this.minHealthyPercentage = minHealthyPercentage;
            return this;
        }

        public final Integer getInstanceWarmup() {
            return this.instanceWarmup;
        }

        public final void setInstanceWarmup(Integer instanceWarmup) {
            this.instanceWarmup = instanceWarmup;
        }

        @Override
        public final Builder instanceWarmup(Integer instanceWarmup) {
            this.instanceWarmup = instanceWarmup;
            return this;
        }

        public final Collection<Integer> getCheckpointPercentages() {
            if (this.checkpointPercentages instanceof SdkAutoConstructList) {
                return null;
            }
            return this.checkpointPercentages;
        }

        public final void setCheckpointPercentages(Collection<Integer> checkpointPercentages) {
            this.checkpointPercentages = CheckpointPercentagesCopier.copy(checkpointPercentages);
        }

        @Override
        public final Builder checkpointPercentages(Collection<Integer> checkpointPercentages) {
            this.checkpointPercentages = CheckpointPercentagesCopier.copy(checkpointPercentages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checkpointPercentages(Integer ... checkpointPercentages) {
            this.checkpointPercentages(Arrays.asList(checkpointPercentages));
            return this;
        }

        public final Integer getCheckpointDelay() {
            return this.checkpointDelay;
        }

        public final void setCheckpointDelay(Integer checkpointDelay) {
            this.checkpointDelay = checkpointDelay;
        }

        @Override
        public final Builder checkpointDelay(Integer checkpointDelay) {
            this.checkpointDelay = checkpointDelay;
            return this;
        }

        public final Boolean getSkipMatching() {
            return this.skipMatching;
        }

        public final void setSkipMatching(Boolean skipMatching) {
            this.skipMatching = skipMatching;
        }

        @Override
        public final Builder skipMatching(Boolean skipMatching) {
            this.skipMatching = skipMatching;
            return this;
        }

        public final Boolean getAutoRollback() {
            return this.autoRollback;
        }

        public final void setAutoRollback(Boolean autoRollback) {
            this.autoRollback = autoRollback;
        }

        @Override
        public final Builder autoRollback(Boolean autoRollback) {
            this.autoRollback = autoRollback;
            return this;
        }

        public final String getScaleInProtectedInstances() {
            return this.scaleInProtectedInstances;
        }

        public final void setScaleInProtectedInstances(String scaleInProtectedInstances) {
            this.scaleInProtectedInstances = scaleInProtectedInstances;
        }

        @Override
        public final Builder scaleInProtectedInstances(String scaleInProtectedInstances) {
            this.scaleInProtectedInstances = scaleInProtectedInstances;
            return this;
        }

        @Override
        public final Builder scaleInProtectedInstances(ScaleInProtectedInstances scaleInProtectedInstances) {
            this.scaleInProtectedInstances(scaleInProtectedInstances == null ? null : scaleInProtectedInstances.toString());
            return this;
        }

        public final String getStandbyInstances() {
            return this.standbyInstances;
        }

        public final void setStandbyInstances(String standbyInstances) {
            this.standbyInstances = standbyInstances;
        }

        @Override
        public final Builder standbyInstances(String standbyInstances) {
            this.standbyInstances = standbyInstances;
            return this;
        }

        @Override
        public final Builder standbyInstances(StandbyInstances standbyInstances) {
            this.standbyInstances(standbyInstances == null ? null : standbyInstances.toString());
            return this;
        }

        public final AlarmSpecification.Builder getAlarmSpecification() {
            return this.alarmSpecification != null ? this.alarmSpecification.toBuilder() : null;
        }

        public final void setAlarmSpecification(AlarmSpecification.BuilderImpl alarmSpecification) {
            this.alarmSpecification = alarmSpecification != null ? alarmSpecification.build() : null;
        }

        @Override
        public final Builder alarmSpecification(AlarmSpecification alarmSpecification) {
            this.alarmSpecification = alarmSpecification;
            return this;
        }

        public final Integer getMaxHealthyPercentage() {
            return this.maxHealthyPercentage;
        }

        public final void setMaxHealthyPercentage(Integer maxHealthyPercentage) {
            this.maxHealthyPercentage = maxHealthyPercentage;
        }

        @Override
        public final Builder maxHealthyPercentage(Integer maxHealthyPercentage) {
            this.maxHealthyPercentage = maxHealthyPercentage;
            return this;
        }

        public RefreshPreferences build() {
            return new RefreshPreferences(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RefreshPreferences> {
        public Builder minHealthyPercentage(Integer var1);

        public Builder instanceWarmup(Integer var1);

        public Builder checkpointPercentages(Collection<Integer> var1);

        public Builder checkpointPercentages(Integer ... var1);

        public Builder checkpointDelay(Integer var1);

        public Builder skipMatching(Boolean var1);

        public Builder autoRollback(Boolean var1);

        public Builder scaleInProtectedInstances(String var1);

        public Builder scaleInProtectedInstances(ScaleInProtectedInstances var1);

        public Builder standbyInstances(String var1);

        public Builder standbyInstances(StandbyInstances var1);

        public Builder alarmSpecification(AlarmSpecification var1);

        default public Builder alarmSpecification(Consumer<AlarmSpecification.Builder> alarmSpecification) {
            return this.alarmSpecification((AlarmSpecification)((AlarmSpecification.Builder)AlarmSpecification.builder().applyMutation(alarmSpecification)).build());
        }

        public Builder maxHealthyPercentage(Integer var1);
    }
}

