/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.autoscaling.AutoScalingAsyncClient;
import software.amazon.awssdk.services.autoscaling.internal.UserAgentUtils;
import software.amazon.awssdk.services.autoscaling.model.DescribeWarmPoolRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeWarmPoolResponse;
import software.amazon.awssdk.services.autoscaling.model.Instance;

public class DescribeWarmPoolPublisher
implements SdkPublisher<DescribeWarmPoolResponse> {
    private final AutoScalingAsyncClient client;
    private final DescribeWarmPoolRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeWarmPoolPublisher(AutoScalingAsyncClient client, DescribeWarmPoolRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeWarmPoolPublisher(AutoScalingAsyncClient client, DescribeWarmPoolRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeWarmPoolResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeWarmPoolResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Instance> instances() {
        Function<DescribeWarmPoolResponse, Iterator> getIterator = response -> {
            if (response != null && response.instances() != null) {
                return response.instances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeWarmPoolResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeWarmPoolResponseFetcher
    implements AsyncPageFetcher<DescribeWarmPoolResponse> {
        private DescribeWarmPoolResponseFetcher() {
        }

        public boolean hasNextPage(DescribeWarmPoolResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeWarmPoolResponse> nextPage(DescribeWarmPoolResponse previousPage) {
            if (previousPage == null) {
                return DescribeWarmPoolPublisher.this.client.describeWarmPool(DescribeWarmPoolPublisher.this.firstRequest);
            }
            return DescribeWarmPoolPublisher.this.client.describeWarmPool((DescribeWarmPoolRequest)((Object)DescribeWarmPoolPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

