/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.autoscaling.AutoScalingClient;
import software.amazon.awssdk.services.autoscaling.AutoScalingClientBuilder;
import software.amazon.awssdk.services.autoscaling.AutoScalingServiceClientConfiguration;
import software.amazon.awssdk.services.autoscaling.DefaultAutoScalingBaseClientBuilder;
import software.amazon.awssdk.services.autoscaling.DefaultAutoScalingClient;
import software.amazon.awssdk.services.autoscaling.endpoints.AutoScalingEndpointProvider;

@SdkInternalApi
final class DefaultAutoScalingClientBuilder
extends DefaultAutoScalingBaseClientBuilder<AutoScalingClientBuilder, AutoScalingClient>
implements AutoScalingClientBuilder {
    DefaultAutoScalingClientBuilder() {
    }

    @Override
    public DefaultAutoScalingClientBuilder endpointProvider(AutoScalingEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AutoScalingClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultAutoScalingClientBuilder.validateClientOptions(clientConfiguration);
        AutoScalingServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultAutoScalingClient client = new DefaultAutoScalingClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private AutoScalingServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return AutoScalingServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

