/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum LifecycleState {
    PENDING("Pending"),

    PENDING_WAIT("Pending:Wait"),

    PENDING_PROCEED("Pending:Proceed"),

    QUARANTINED("Quarantined"),

    IN_SERVICE("InService"),

    TERMINATING("Terminating"),

    TERMINATING_WAIT("Terminating:Wait"),

    TERMINATING_PROCEED("Terminating:Proceed"),

    TERMINATED("Terminated"),

    DETACHING("Detaching"),

    DETACHED("Detached"),

    ENTERING_STANDBY("EnteringStandby"),

    STANDBY("Standby"),

    WARMED_PENDING("Warmed:Pending"),

    WARMED_PENDING_WAIT("Warmed:Pending:Wait"),

    WARMED_PENDING_PROCEED("Warmed:Pending:Proceed"),

    WARMED_TERMINATING("Warmed:Terminating"),

    WARMED_TERMINATING_WAIT("Warmed:Terminating:Wait"),

    WARMED_TERMINATING_PROCEED("Warmed:Terminating:Proceed"),

    WARMED_TERMINATED("Warmed:Terminated"),

    WARMED_STOPPED("Warmed:Stopped"),

    WARMED_RUNNING("Warmed:Running"),

    WARMED_HIBERNATED("Warmed:Hibernated"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LifecycleState> VALUE_MAP = EnumUtils.uniqueIndex(LifecycleState.class,
            LifecycleState::toString);

    private final String value;

    private LifecycleState(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return LifecycleState corresponding to the value
     */
    public static LifecycleState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link LifecycleState}s
     */
    public static Set<LifecycleState> knownValues() {
        Set<LifecycleState> knownValues = EnumSet.allOf(LifecycleState.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
