/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.services.autoscaling.model.LifecycleHookNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLifecycleHooksRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, DescribeLifecycleHooksRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingGroupName").getter(DescribeLifecycleHooksRequest.getter(DescribeLifecycleHooksRequest::autoScalingGroupName)).setter(DescribeLifecycleHooksRequest.setter(Builder::autoScalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build()}).build();
    private static final SdkField<List<String>> LIFECYCLE_HOOK_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LifecycleHookNames").getter(DescribeLifecycleHooksRequest.getter(DescribeLifecycleHooksRequest::lifecycleHookNames)).setter(DescribeLifecycleHooksRequest.setter(Builder::lifecycleHookNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleHookNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD, LIFECYCLE_HOOK_NAMES_FIELD));
    private final String autoScalingGroupName;
    private final List<String> lifecycleHookNames;

    private DescribeLifecycleHooksRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.lifecycleHookNames = builder.lifecycleHookNames;
    }

    public final String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public final boolean hasLifecycleHookNames() {
        return this.lifecycleHookNames != null && !(this.lifecycleHookNames instanceof SdkAutoConstructList);
    }

    public final List<String> lifecycleHookNames() {
        return this.lifecycleHookNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLifecycleHookNames() ? this.lifecycleHookNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLifecycleHooksRequest)) {
            return false;
        }
        DescribeLifecycleHooksRequest other = (DescribeLifecycleHooksRequest)((Object)obj);
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && this.hasLifecycleHookNames() == other.hasLifecycleHookNames() && Objects.equals(this.lifecycleHookNames(), other.lifecycleHookNames());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeLifecycleHooksRequest").add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("LifecycleHookNames", this.hasLifecycleHookNames() ? this.lifecycleHookNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "LifecycleHookNames": {
                return Optional.ofNullable(clazz.cast(this.lifecycleHookNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLifecycleHooksRequest, T> g) {
        return obj -> g.apply((DescribeLifecycleHooksRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private List<String> lifecycleHookNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLifecycleHooksRequest model) {
            super(model);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.lifecycleHookNames(model.lifecycleHookNames);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        @Transient
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final Collection<String> getLifecycleHookNames() {
            if (this.lifecycleHookNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lifecycleHookNames;
        }

        public final void setLifecycleHookNames(Collection<String> lifecycleHookNames) {
            this.lifecycleHookNames = LifecycleHookNamesCopier.copy(lifecycleHookNames);
        }

        @Override
        @Transient
        public final Builder lifecycleHookNames(Collection<String> lifecycleHookNames) {
            this.lifecycleHookNames = LifecycleHookNamesCopier.copy(lifecycleHookNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder lifecycleHookNames(String ... lifecycleHookNames) {
            this.lifecycleHookNames(Arrays.asList(lifecycleHookNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeLifecycleHooksRequest build() {
            return new DescribeLifecycleHooksRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLifecycleHooksRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder lifecycleHookNames(Collection<String> var1);

        public Builder lifecycleHookNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

