/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.Alarm;
import software.amazon.awssdk.services.autoscaling.model.AlarmsCopier;
import software.amazon.awssdk.services.autoscaling.model.PredictiveScalingConfiguration;
import software.amazon.awssdk.services.autoscaling.model.StepAdjustment;
import software.amazon.awssdk.services.autoscaling.model.StepAdjustmentsCopier;
import software.amazon.awssdk.services.autoscaling.model.TargetTrackingConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScalingPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScalingPolicy> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingGroupName").getter(ScalingPolicy.getter(ScalingPolicy::autoScalingGroupName)).setter(ScalingPolicy.setter(Builder::autoScalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build()}).build();
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyName").getter(ScalingPolicy.getter(ScalingPolicy::policyName)).setter(ScalingPolicy.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()}).build();
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyARN").getter(ScalingPolicy.getter(ScalingPolicy::policyARN)).setter(ScalingPolicy.setter(Builder::policyARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyARN").build()}).build();
    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyType").getter(ScalingPolicy.getter(ScalingPolicy::policyType)).setter(ScalingPolicy.setter(Builder::policyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()}).build();
    private static final SdkField<String> ADJUSTMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdjustmentType").getter(ScalingPolicy.getter(ScalingPolicy::adjustmentType)).setter(ScalingPolicy.setter(Builder::adjustmentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdjustmentType").build()}).build();
    private static final SdkField<Integer> MIN_ADJUSTMENT_STEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinAdjustmentStep").getter(ScalingPolicy.getter(ScalingPolicy::minAdjustmentStep)).setter(ScalingPolicy.setter(Builder::minAdjustmentStep)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinAdjustmentStep").build()}).build();
    private static final SdkField<Integer> MIN_ADJUSTMENT_MAGNITUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinAdjustmentMagnitude").getter(ScalingPolicy.getter(ScalingPolicy::minAdjustmentMagnitude)).setter(ScalingPolicy.setter(Builder::minAdjustmentMagnitude)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinAdjustmentMagnitude").build()}).build();
    private static final SdkField<Integer> SCALING_ADJUSTMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ScalingAdjustment").getter(ScalingPolicy.getter(ScalingPolicy::scalingAdjustment)).setter(ScalingPolicy.setter(Builder::scalingAdjustment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingAdjustment").build()}).build();
    private static final SdkField<Integer> COOLDOWN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Cooldown").getter(ScalingPolicy.getter(ScalingPolicy::cooldown)).setter(ScalingPolicy.setter(Builder::cooldown)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cooldown").build()}).build();
    private static final SdkField<List<StepAdjustment>> STEP_ADJUSTMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StepAdjustments").getter(ScalingPolicy.getter(ScalingPolicy::stepAdjustments)).setter(ScalingPolicy.setter(Builder::stepAdjustments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepAdjustments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StepAdjustment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> METRIC_AGGREGATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricAggregationType").getter(ScalingPolicy.getter(ScalingPolicy::metricAggregationType)).setter(ScalingPolicy.setter(Builder::metricAggregationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricAggregationType").build()}).build();
    private static final SdkField<Integer> ESTIMATED_INSTANCE_WARMUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EstimatedInstanceWarmup").getter(ScalingPolicy.getter(ScalingPolicy::estimatedInstanceWarmup)).setter(ScalingPolicy.setter(Builder::estimatedInstanceWarmup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedInstanceWarmup").build()}).build();
    private static final SdkField<List<Alarm>> ALARMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Alarms").getter(ScalingPolicy.getter(ScalingPolicy::alarms)).setter(ScalingPolicy.setter(Builder::alarms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alarms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Alarm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TargetTrackingConfiguration> TARGET_TRACKING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetTrackingConfiguration").getter(ScalingPolicy.getter(ScalingPolicy::targetTrackingConfiguration)).setter(ScalingPolicy.setter(Builder::targetTrackingConfiguration)).constructor(TargetTrackingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTrackingConfiguration").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(ScalingPolicy.getter(ScalingPolicy::enabled)).setter(ScalingPolicy.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<PredictiveScalingConfiguration> PREDICTIVE_SCALING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PredictiveScalingConfiguration").getter(ScalingPolicy.getter(ScalingPolicy::predictiveScalingConfiguration)).setter(ScalingPolicy.setter(Builder::predictiveScalingConfiguration)).constructor(PredictiveScalingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictiveScalingConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD, POLICY_NAME_FIELD, POLICY_ARN_FIELD, POLICY_TYPE_FIELD, ADJUSTMENT_TYPE_FIELD, MIN_ADJUSTMENT_STEP_FIELD, MIN_ADJUSTMENT_MAGNITUDE_FIELD, SCALING_ADJUSTMENT_FIELD, COOLDOWN_FIELD, STEP_ADJUSTMENTS_FIELD, METRIC_AGGREGATION_TYPE_FIELD, ESTIMATED_INSTANCE_WARMUP_FIELD, ALARMS_FIELD, TARGET_TRACKING_CONFIGURATION_FIELD, ENABLED_FIELD, PREDICTIVE_SCALING_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String autoScalingGroupName;
    private final String policyName;
    private final String policyARN;
    private final String policyType;
    private final String adjustmentType;
    private final Integer minAdjustmentStep;
    private final Integer minAdjustmentMagnitude;
    private final Integer scalingAdjustment;
    private final Integer cooldown;
    private final List<StepAdjustment> stepAdjustments;
    private final String metricAggregationType;
    private final Integer estimatedInstanceWarmup;
    private final List<Alarm> alarms;
    private final TargetTrackingConfiguration targetTrackingConfiguration;
    private final Boolean enabled;
    private final PredictiveScalingConfiguration predictiveScalingConfiguration;

    private ScalingPolicy(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.policyName = builder.policyName;
        this.policyARN = builder.policyARN;
        this.policyType = builder.policyType;
        this.adjustmentType = builder.adjustmentType;
        this.minAdjustmentStep = builder.minAdjustmentStep;
        this.minAdjustmentMagnitude = builder.minAdjustmentMagnitude;
        this.scalingAdjustment = builder.scalingAdjustment;
        this.cooldown = builder.cooldown;
        this.stepAdjustments = builder.stepAdjustments;
        this.metricAggregationType = builder.metricAggregationType;
        this.estimatedInstanceWarmup = builder.estimatedInstanceWarmup;
        this.alarms = builder.alarms;
        this.targetTrackingConfiguration = builder.targetTrackingConfiguration;
        this.enabled = builder.enabled;
        this.predictiveScalingConfiguration = builder.predictiveScalingConfiguration;
    }

    public final String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public final String policyName() {
        return this.policyName;
    }

    public final String policyARN() {
        return this.policyARN;
    }

    public final String policyType() {
        return this.policyType;
    }

    public final String adjustmentType() {
        return this.adjustmentType;
    }

    public final Integer minAdjustmentStep() {
        return this.minAdjustmentStep;
    }

    public final Integer minAdjustmentMagnitude() {
        return this.minAdjustmentMagnitude;
    }

    public final Integer scalingAdjustment() {
        return this.scalingAdjustment;
    }

    public final Integer cooldown() {
        return this.cooldown;
    }

    public final boolean hasStepAdjustments() {
        return this.stepAdjustments != null && !(this.stepAdjustments instanceof SdkAutoConstructList);
    }

    public final List<StepAdjustment> stepAdjustments() {
        return this.stepAdjustments;
    }

    public final String metricAggregationType() {
        return this.metricAggregationType;
    }

    public final Integer estimatedInstanceWarmup() {
        return this.estimatedInstanceWarmup;
    }

    public final boolean hasAlarms() {
        return this.alarms != null && !(this.alarms instanceof SdkAutoConstructList);
    }

    public final List<Alarm> alarms() {
        return this.alarms;
    }

    public final TargetTrackingConfiguration targetTrackingConfiguration() {
        return this.targetTrackingConfiguration;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final PredictiveScalingConfiguration predictiveScalingConfiguration() {
        return this.predictiveScalingConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyType());
        hashCode = 31 * hashCode + Objects.hashCode(this.adjustmentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.minAdjustmentStep());
        hashCode = 31 * hashCode + Objects.hashCode(this.minAdjustmentMagnitude());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingAdjustment());
        hashCode = 31 * hashCode + Objects.hashCode(this.cooldown());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStepAdjustments() ? this.stepAdjustments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.metricAggregationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedInstanceWarmup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlarms() ? this.alarms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTrackingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictiveScalingConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingPolicy)) {
            return false;
        }
        ScalingPolicy other = (ScalingPolicy)obj;
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.policyARN(), other.policyARN()) && Objects.equals(this.policyType(), other.policyType()) && Objects.equals(this.adjustmentType(), other.adjustmentType()) && Objects.equals(this.minAdjustmentStep(), other.minAdjustmentStep()) && Objects.equals(this.minAdjustmentMagnitude(), other.minAdjustmentMagnitude()) && Objects.equals(this.scalingAdjustment(), other.scalingAdjustment()) && Objects.equals(this.cooldown(), other.cooldown()) && this.hasStepAdjustments() == other.hasStepAdjustments() && Objects.equals(this.stepAdjustments(), other.stepAdjustments()) && Objects.equals(this.metricAggregationType(), other.metricAggregationType()) && Objects.equals(this.estimatedInstanceWarmup(), other.estimatedInstanceWarmup()) && this.hasAlarms() == other.hasAlarms() && Objects.equals(this.alarms(), other.alarms()) && Objects.equals(this.targetTrackingConfiguration(), other.targetTrackingConfiguration()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.predictiveScalingConfiguration(), other.predictiveScalingConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ScalingPolicy").add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("PolicyName", (Object)this.policyName()).add("PolicyARN", (Object)this.policyARN()).add("PolicyType", (Object)this.policyType()).add("AdjustmentType", (Object)this.adjustmentType()).add("MinAdjustmentStep", (Object)this.minAdjustmentStep()).add("MinAdjustmentMagnitude", (Object)this.minAdjustmentMagnitude()).add("ScalingAdjustment", (Object)this.scalingAdjustment()).add("Cooldown", (Object)this.cooldown()).add("StepAdjustments", this.hasStepAdjustments() ? this.stepAdjustments() : null).add("MetricAggregationType", (Object)this.metricAggregationType()).add("EstimatedInstanceWarmup", (Object)this.estimatedInstanceWarmup()).add("Alarms", this.hasAlarms() ? this.alarms() : null).add("TargetTrackingConfiguration", (Object)this.targetTrackingConfiguration()).add("Enabled", (Object)this.enabled()).add("PredictiveScalingConfiguration", (Object)this.predictiveScalingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "PolicyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "PolicyARN": {
                return Optional.ofNullable(clazz.cast(this.policyARN()));
            }
            case "PolicyType": {
                return Optional.ofNullable(clazz.cast(this.policyType()));
            }
            case "AdjustmentType": {
                return Optional.ofNullable(clazz.cast(this.adjustmentType()));
            }
            case "MinAdjustmentStep": {
                return Optional.ofNullable(clazz.cast(this.minAdjustmentStep()));
            }
            case "MinAdjustmentMagnitude": {
                return Optional.ofNullable(clazz.cast(this.minAdjustmentMagnitude()));
            }
            case "ScalingAdjustment": {
                return Optional.ofNullable(clazz.cast(this.scalingAdjustment()));
            }
            case "Cooldown": {
                return Optional.ofNullable(clazz.cast(this.cooldown()));
            }
            case "StepAdjustments": {
                return Optional.ofNullable(clazz.cast(this.stepAdjustments()));
            }
            case "MetricAggregationType": {
                return Optional.ofNullable(clazz.cast(this.metricAggregationType()));
            }
            case "EstimatedInstanceWarmup": {
                return Optional.ofNullable(clazz.cast(this.estimatedInstanceWarmup()));
            }
            case "Alarms": {
                return Optional.ofNullable(clazz.cast(this.alarms()));
            }
            case "TargetTrackingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.targetTrackingConfiguration()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "PredictiveScalingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.predictiveScalingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScalingPolicy, T> g) {
        return obj -> g.apply((ScalingPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private String policyName;
        private String policyARN;
        private String policyType;
        private String adjustmentType;
        private Integer minAdjustmentStep;
        private Integer minAdjustmentMagnitude;
        private Integer scalingAdjustment;
        private Integer cooldown;
        private List<StepAdjustment> stepAdjustments = DefaultSdkAutoConstructList.getInstance();
        private String metricAggregationType;
        private Integer estimatedInstanceWarmup;
        private List<Alarm> alarms = DefaultSdkAutoConstructList.getInstance();
        private TargetTrackingConfiguration targetTrackingConfiguration;
        private Boolean enabled;
        private PredictiveScalingConfiguration predictiveScalingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingPolicy model) {
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.policyName(model.policyName);
            this.policyARN(model.policyARN);
            this.policyType(model.policyType);
            this.adjustmentType(model.adjustmentType);
            this.minAdjustmentStep(model.minAdjustmentStep);
            this.minAdjustmentMagnitude(model.minAdjustmentMagnitude);
            this.scalingAdjustment(model.scalingAdjustment);
            this.cooldown(model.cooldown);
            this.stepAdjustments(model.stepAdjustments);
            this.metricAggregationType(model.metricAggregationType);
            this.estimatedInstanceWarmup(model.estimatedInstanceWarmup);
            this.alarms(model.alarms);
            this.targetTrackingConfiguration(model.targetTrackingConfiguration);
            this.enabled(model.enabled);
            this.predictiveScalingConfiguration(model.predictiveScalingConfiguration);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        @Transient
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        @Transient
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getPolicyARN() {
            return this.policyARN;
        }

        public final void setPolicyARN(String policyARN) {
            this.policyARN = policyARN;
        }

        @Override
        @Transient
        public final Builder policyARN(String policyARN) {
            this.policyARN = policyARN;
            return this;
        }

        public final String getPolicyType() {
            return this.policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        @Transient
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        public final String getAdjustmentType() {
            return this.adjustmentType;
        }

        public final void setAdjustmentType(String adjustmentType) {
            this.adjustmentType = adjustmentType;
        }

        @Override
        @Transient
        public final Builder adjustmentType(String adjustmentType) {
            this.adjustmentType = adjustmentType;
            return this;
        }

        public final Integer getMinAdjustmentStep() {
            return this.minAdjustmentStep;
        }

        public final void setMinAdjustmentStep(Integer minAdjustmentStep) {
            this.minAdjustmentStep = minAdjustmentStep;
        }

        @Override
        @Transient
        public final Builder minAdjustmentStep(Integer minAdjustmentStep) {
            this.minAdjustmentStep = minAdjustmentStep;
            return this;
        }

        public final Integer getMinAdjustmentMagnitude() {
            return this.minAdjustmentMagnitude;
        }

        public final void setMinAdjustmentMagnitude(Integer minAdjustmentMagnitude) {
            this.minAdjustmentMagnitude = minAdjustmentMagnitude;
        }

        @Override
        @Transient
        public final Builder minAdjustmentMagnitude(Integer minAdjustmentMagnitude) {
            this.minAdjustmentMagnitude = minAdjustmentMagnitude;
            return this;
        }

        public final Integer getScalingAdjustment() {
            return this.scalingAdjustment;
        }

        public final void setScalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
        }

        @Override
        @Transient
        public final Builder scalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
            return this;
        }

        public final Integer getCooldown() {
            return this.cooldown;
        }

        public final void setCooldown(Integer cooldown) {
            this.cooldown = cooldown;
        }

        @Override
        @Transient
        public final Builder cooldown(Integer cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public final List<StepAdjustment.Builder> getStepAdjustments() {
            List<StepAdjustment.Builder> result = StepAdjustmentsCopier.copyToBuilder(this.stepAdjustments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStepAdjustments(Collection<StepAdjustment.BuilderImpl> stepAdjustments) {
            this.stepAdjustments = StepAdjustmentsCopier.copyFromBuilder(stepAdjustments);
        }

        @Override
        @Transient
        public final Builder stepAdjustments(Collection<StepAdjustment> stepAdjustments) {
            this.stepAdjustments = StepAdjustmentsCopier.copy(stepAdjustments);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder stepAdjustments(StepAdjustment ... stepAdjustments) {
            this.stepAdjustments(Arrays.asList(stepAdjustments));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder stepAdjustments(Consumer<StepAdjustment.Builder> ... stepAdjustments) {
            this.stepAdjustments(Stream.of(stepAdjustments).map(c -> (StepAdjustment)((StepAdjustment.Builder)StepAdjustment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMetricAggregationType() {
            return this.metricAggregationType;
        }

        public final void setMetricAggregationType(String metricAggregationType) {
            this.metricAggregationType = metricAggregationType;
        }

        @Override
        @Transient
        public final Builder metricAggregationType(String metricAggregationType) {
            this.metricAggregationType = metricAggregationType;
            return this;
        }

        public final Integer getEstimatedInstanceWarmup() {
            return this.estimatedInstanceWarmup;
        }

        public final void setEstimatedInstanceWarmup(Integer estimatedInstanceWarmup) {
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
        }

        @Override
        @Transient
        public final Builder estimatedInstanceWarmup(Integer estimatedInstanceWarmup) {
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
            return this;
        }

        public final List<Alarm.Builder> getAlarms() {
            List<Alarm.Builder> result = AlarmsCopier.copyToBuilder(this.alarms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAlarms(Collection<Alarm.BuilderImpl> alarms) {
            this.alarms = AlarmsCopier.copyFromBuilder(alarms);
        }

        @Override
        @Transient
        public final Builder alarms(Collection<Alarm> alarms) {
            this.alarms = AlarmsCopier.copy(alarms);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder alarms(Alarm ... alarms) {
            this.alarms(Arrays.asList(alarms));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder alarms(Consumer<Alarm.Builder> ... alarms) {
            this.alarms(Stream.of(alarms).map(c -> (Alarm)((Alarm.Builder)Alarm.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TargetTrackingConfiguration.Builder getTargetTrackingConfiguration() {
            return this.targetTrackingConfiguration != null ? this.targetTrackingConfiguration.toBuilder() : null;
        }

        public final void setTargetTrackingConfiguration(TargetTrackingConfiguration.BuilderImpl targetTrackingConfiguration) {
            this.targetTrackingConfiguration = targetTrackingConfiguration != null ? targetTrackingConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder targetTrackingConfiguration(TargetTrackingConfiguration targetTrackingConfiguration) {
            this.targetTrackingConfiguration = targetTrackingConfiguration;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        @Transient
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final PredictiveScalingConfiguration.Builder getPredictiveScalingConfiguration() {
            return this.predictiveScalingConfiguration != null ? this.predictiveScalingConfiguration.toBuilder() : null;
        }

        public final void setPredictiveScalingConfiguration(PredictiveScalingConfiguration.BuilderImpl predictiveScalingConfiguration) {
            this.predictiveScalingConfiguration = predictiveScalingConfiguration != null ? predictiveScalingConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder predictiveScalingConfiguration(PredictiveScalingConfiguration predictiveScalingConfiguration) {
            this.predictiveScalingConfiguration = predictiveScalingConfiguration;
            return this;
        }

        public ScalingPolicy build() {
            return new ScalingPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScalingPolicy> {
        public Builder autoScalingGroupName(String var1);

        public Builder policyName(String var1);

        public Builder policyARN(String var1);

        public Builder policyType(String var1);

        public Builder adjustmentType(String var1);

        public Builder minAdjustmentStep(Integer var1);

        public Builder minAdjustmentMagnitude(Integer var1);

        public Builder scalingAdjustment(Integer var1);

        public Builder cooldown(Integer var1);

        public Builder stepAdjustments(Collection<StepAdjustment> var1);

        public Builder stepAdjustments(StepAdjustment ... var1);

        public Builder stepAdjustments(Consumer<StepAdjustment.Builder> ... var1);

        public Builder metricAggregationType(String var1);

        public Builder estimatedInstanceWarmup(Integer var1);

        public Builder alarms(Collection<Alarm> var1);

        public Builder alarms(Alarm ... var1);

        public Builder alarms(Consumer<Alarm.Builder> ... var1);

        public Builder targetTrackingConfiguration(TargetTrackingConfiguration var1);

        default public Builder targetTrackingConfiguration(Consumer<TargetTrackingConfiguration.Builder> targetTrackingConfiguration) {
            return this.targetTrackingConfiguration((TargetTrackingConfiguration)((TargetTrackingConfiguration.Builder)TargetTrackingConfiguration.builder().applyMutation(targetTrackingConfiguration)).build());
        }

        public Builder enabled(Boolean var1);

        public Builder predictiveScalingConfiguration(PredictiveScalingConfiguration var1);

        default public Builder predictiveScalingConfiguration(Consumer<PredictiveScalingConfiguration.Builder> predictiveScalingConfiguration) {
            return this.predictiveScalingConfiguration((PredictiveScalingConfiguration)((PredictiveScalingConfiguration.Builder)PredictiveScalingConfiguration.builder().applyMutation(predictiveScalingConfiguration)).build());
        }
    }
}

