/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AcceleratorType {
    GPU("gpu"),
    FPGA("fpga"),
    INFERENCE("inference"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AcceleratorType> VALUE_MAP;
    private final String value;

    private AcceleratorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AcceleratorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AcceleratorType> knownValues() {
        EnumSet<AcceleratorType> knownValues = EnumSet.allOf(AcceleratorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AcceleratorType.class, AcceleratorType::toString);
    }
}

