/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutLifecycleHookRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, PutLifecycleHookRequest> {
    private static final SdkField<String> LIFECYCLE_HOOK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LifecycleHookName").getter(PutLifecycleHookRequest.getter(PutLifecycleHookRequest::lifecycleHookName)).setter(PutLifecycleHookRequest.setter(Builder::lifecycleHookName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleHookName").build()}).build();
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingGroupName").getter(PutLifecycleHookRequest.getter(PutLifecycleHookRequest::autoScalingGroupName)).setter(PutLifecycleHookRequest.setter(Builder::autoScalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build()}).build();
    private static final SdkField<String> LIFECYCLE_TRANSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LifecycleTransition").getter(PutLifecycleHookRequest.getter(PutLifecycleHookRequest::lifecycleTransition)).setter(PutLifecycleHookRequest.setter(Builder::lifecycleTransition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleTransition").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(PutLifecycleHookRequest.getter(PutLifecycleHookRequest::roleARN)).setter(PutLifecycleHookRequest.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<String> NOTIFICATION_TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotificationTargetARN").getter(PutLifecycleHookRequest.getter(PutLifecycleHookRequest::notificationTargetARN)).setter(PutLifecycleHookRequest.setter(Builder::notificationTargetARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationTargetARN").build()}).build();
    private static final SdkField<String> NOTIFICATION_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotificationMetadata").getter(PutLifecycleHookRequest.getter(PutLifecycleHookRequest::notificationMetadata)).setter(PutLifecycleHookRequest.setter(Builder::notificationMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationMetadata").build()}).build();
    private static final SdkField<Integer> HEARTBEAT_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HeartbeatTimeout").getter(PutLifecycleHookRequest.getter(PutLifecycleHookRequest::heartbeatTimeout)).setter(PutLifecycleHookRequest.setter(Builder::heartbeatTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeartbeatTimeout").build()}).build();
    private static final SdkField<String> DEFAULT_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultResult").getter(PutLifecycleHookRequest.getter(PutLifecycleHookRequest::defaultResult)).setter(PutLifecycleHookRequest.setter(Builder::defaultResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultResult").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_HOOK_NAME_FIELD, AUTO_SCALING_GROUP_NAME_FIELD, LIFECYCLE_TRANSITION_FIELD, ROLE_ARN_FIELD, NOTIFICATION_TARGET_ARN_FIELD, NOTIFICATION_METADATA_FIELD, HEARTBEAT_TIMEOUT_FIELD, DEFAULT_RESULT_FIELD));
    private final String lifecycleHookName;
    private final String autoScalingGroupName;
    private final String lifecycleTransition;
    private final String roleARN;
    private final String notificationTargetARN;
    private final String notificationMetadata;
    private final Integer heartbeatTimeout;
    private final String defaultResult;

    private PutLifecycleHookRequest(BuilderImpl builder) {
        super(builder);
        this.lifecycleHookName = builder.lifecycleHookName;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.lifecycleTransition = builder.lifecycleTransition;
        this.roleARN = builder.roleARN;
        this.notificationTargetARN = builder.notificationTargetARN;
        this.notificationMetadata = builder.notificationMetadata;
        this.heartbeatTimeout = builder.heartbeatTimeout;
        this.defaultResult = builder.defaultResult;
    }

    public final String lifecycleHookName() {
        return this.lifecycleHookName;
    }

    public final String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public final String lifecycleTransition() {
        return this.lifecycleTransition;
    }

    public final String roleARN() {
        return this.roleARN;
    }

    public final String notificationTargetARN() {
        return this.notificationTargetARN;
    }

    public final String notificationMetadata() {
        return this.notificationMetadata;
    }

    public final Integer heartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    public final String defaultResult() {
        return this.defaultResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleHookName());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleTransition());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationTargetARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.heartbeatTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultResult());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutLifecycleHookRequest)) {
            return false;
        }
        PutLifecycleHookRequest other = (PutLifecycleHookRequest)((Object)obj);
        return Objects.equals(this.lifecycleHookName(), other.lifecycleHookName()) && Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.lifecycleTransition(), other.lifecycleTransition()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.notificationTargetARN(), other.notificationTargetARN()) && Objects.equals(this.notificationMetadata(), other.notificationMetadata()) && Objects.equals(this.heartbeatTimeout(), other.heartbeatTimeout()) && Objects.equals(this.defaultResult(), other.defaultResult());
    }

    public final String toString() {
        return ToString.builder((String)"PutLifecycleHookRequest").add("LifecycleHookName", (Object)this.lifecycleHookName()).add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("LifecycleTransition", (Object)this.lifecycleTransition()).add("RoleARN", (Object)this.roleARN()).add("NotificationTargetARN", (Object)this.notificationTargetARN()).add("NotificationMetadata", (Object)this.notificationMetadata()).add("HeartbeatTimeout", (Object)this.heartbeatTimeout()).add("DefaultResult", (Object)this.defaultResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LifecycleHookName": {
                return Optional.ofNullable(clazz.cast(this.lifecycleHookName()));
            }
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "LifecycleTransition": {
                return Optional.ofNullable(clazz.cast(this.lifecycleTransition()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "NotificationTargetARN": {
                return Optional.ofNullable(clazz.cast(this.notificationTargetARN()));
            }
            case "NotificationMetadata": {
                return Optional.ofNullable(clazz.cast(this.notificationMetadata()));
            }
            case "HeartbeatTimeout": {
                return Optional.ofNullable(clazz.cast(this.heartbeatTimeout()));
            }
            case "DefaultResult": {
                return Optional.ofNullable(clazz.cast(this.defaultResult()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutLifecycleHookRequest, T> g) {
        return obj -> g.apply((PutLifecycleHookRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String lifecycleHookName;
        private String autoScalingGroupName;
        private String lifecycleTransition;
        private String roleARN;
        private String notificationTargetARN;
        private String notificationMetadata;
        private Integer heartbeatTimeout;
        private String defaultResult;

        private BuilderImpl() {
        }

        private BuilderImpl(PutLifecycleHookRequest model) {
            super(model);
            this.lifecycleHookName(model.lifecycleHookName);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.lifecycleTransition(model.lifecycleTransition);
            this.roleARN(model.roleARN);
            this.notificationTargetARN(model.notificationTargetARN);
            this.notificationMetadata(model.notificationMetadata);
            this.heartbeatTimeout(model.heartbeatTimeout);
            this.defaultResult(model.defaultResult);
        }

        public final String getLifecycleHookName() {
            return this.lifecycleHookName;
        }

        public final void setLifecycleHookName(String lifecycleHookName) {
            this.lifecycleHookName = lifecycleHookName;
        }

        @Override
        @Transient
        public final Builder lifecycleHookName(String lifecycleHookName) {
            this.lifecycleHookName = lifecycleHookName;
            return this;
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        @Transient
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final String getLifecycleTransition() {
            return this.lifecycleTransition;
        }

        public final void setLifecycleTransition(String lifecycleTransition) {
            this.lifecycleTransition = lifecycleTransition;
        }

        @Override
        @Transient
        public final Builder lifecycleTransition(String lifecycleTransition) {
            this.lifecycleTransition = lifecycleTransition;
            return this;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        @Transient
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final String getNotificationTargetARN() {
            return this.notificationTargetARN;
        }

        public final void setNotificationTargetARN(String notificationTargetARN) {
            this.notificationTargetARN = notificationTargetARN;
        }

        @Override
        @Transient
        public final Builder notificationTargetARN(String notificationTargetARN) {
            this.notificationTargetARN = notificationTargetARN;
            return this;
        }

        public final String getNotificationMetadata() {
            return this.notificationMetadata;
        }

        public final void setNotificationMetadata(String notificationMetadata) {
            this.notificationMetadata = notificationMetadata;
        }

        @Override
        @Transient
        public final Builder notificationMetadata(String notificationMetadata) {
            this.notificationMetadata = notificationMetadata;
            return this;
        }

        public final Integer getHeartbeatTimeout() {
            return this.heartbeatTimeout;
        }

        public final void setHeartbeatTimeout(Integer heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
        }

        @Override
        @Transient
        public final Builder heartbeatTimeout(Integer heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
            return this;
        }

        public final String getDefaultResult() {
            return this.defaultResult;
        }

        public final void setDefaultResult(String defaultResult) {
            this.defaultResult = defaultResult;
        }

        @Override
        @Transient
        public final Builder defaultResult(String defaultResult) {
            this.defaultResult = defaultResult;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutLifecycleHookRequest build() {
            return new PutLifecycleHookRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutLifecycleHookRequest> {
        public Builder lifecycleHookName(String var1);

        public Builder autoScalingGroupName(String var1);

        public Builder lifecycleTransition(String var1);

        public Builder roleARN(String var1);

        public Builder notificationTargetARN(String var1);

        public Builder notificationMetadata(String var1);

        public Builder heartbeatTimeout(Integer var1);

        public Builder defaultResult(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

