/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LifecycleState {
    PENDING("Pending"),
    PENDING_WAIT("Pending:Wait"),
    PENDING_PROCEED("Pending:Proceed"),
    QUARANTINED("Quarantined"),
    IN_SERVICE("InService"),
    TERMINATING("Terminating"),
    TERMINATING_WAIT("Terminating:Wait"),
    TERMINATING_PROCEED("Terminating:Proceed"),
    TERMINATED("Terminated"),
    DETACHING("Detaching"),
    DETACHED("Detached"),
    ENTERING_STANDBY("EnteringStandby"),
    STANDBY("Standby"),
    WARMED_PENDING("Warmed:Pending"),
    WARMED_PENDING_WAIT("Warmed:Pending:Wait"),
    WARMED_PENDING_PROCEED("Warmed:Pending:Proceed"),
    WARMED_TERMINATING("Warmed:Terminating"),
    WARMED_TERMINATING_WAIT("Warmed:Terminating:Wait"),
    WARMED_TERMINATING_PROCEED("Warmed:Terminating:Proceed"),
    WARMED_TERMINATED("Warmed:Terminated"),
    WARMED_STOPPED("Warmed:Stopped"),
    WARMED_RUNNING("Warmed:Running"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LifecycleState> VALUE_MAP;
    private final String value;

    private LifecycleState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LifecycleState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LifecycleState> knownValues() {
        EnumSet<LifecycleState> knownValues = EnumSet.allOf(LifecycleState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LifecycleState.class, LifecycleState::toString);
    }
}

