/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes information used to start an instance refresh.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RefreshPreferences implements SdkPojo, Serializable,
        ToCopyableBuilder<RefreshPreferences.Builder, RefreshPreferences> {
    private static final SdkField<Integer> MIN_HEALTHY_PERCENTAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinHealthyPercentage").getter(getter(RefreshPreferences::minHealthyPercentage))
            .setter(setter(Builder::minHealthyPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinHealthyPercentage").build())
            .build();

    private static final SdkField<Integer> INSTANCE_WARMUP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceWarmup").getter(getter(RefreshPreferences::instanceWarmup))
            .setter(setter(Builder::instanceWarmup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceWarmup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_HEALTHY_PERCENTAGE_FIELD,
            INSTANCE_WARMUP_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer minHealthyPercentage;

    private final Integer instanceWarmup;

    private RefreshPreferences(BuilderImpl builder) {
        this.minHealthyPercentage = builder.minHealthyPercentage;
        this.instanceWarmup = builder.instanceWarmup;
    }

    /**
     * <p>
     * The amount of capacity in the Auto Scaling group that must remain healthy during an instance refresh to allow the
     * operation to continue, as a percentage of the desired capacity of the Auto Scaling group (rounded up to the
     * nearest integer). The default is <code>90</code>.
     * </p>
     * 
     * @return The amount of capacity in the Auto Scaling group that must remain healthy during an instance refresh to
     *         allow the operation to continue, as a percentage of the desired capacity of the Auto Scaling group
     *         (rounded up to the nearest integer). The default is <code>90</code>.
     */
    public final Integer minHealthyPercentage() {
        return minHealthyPercentage;
    }

    /**
     * <p>
     * The number of seconds until a newly launched instance is configured and ready to use. During this time, Amazon
     * EC2 Auto Scaling does not immediately move on to the next replacement. The default is to use the value for the
     * health check grace period defined for the group.
     * </p>
     * 
     * @return The number of seconds until a newly launched instance is configured and ready to use. During this time,
     *         Amazon EC2 Auto Scaling does not immediately move on to the next replacement. The default is to use the
     *         value for the health check grace period defined for the group.
     */
    public final Integer instanceWarmup() {
        return instanceWarmup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minHealthyPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(instanceWarmup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefreshPreferences)) {
            return false;
        }
        RefreshPreferences other = (RefreshPreferences) obj;
        return Objects.equals(minHealthyPercentage(), other.minHealthyPercentage())
                && Objects.equals(instanceWarmup(), other.instanceWarmup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RefreshPreferences").add("MinHealthyPercentage", minHealthyPercentage())
                .add("InstanceWarmup", instanceWarmup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinHealthyPercentage":
            return Optional.ofNullable(clazz.cast(minHealthyPercentage()));
        case "InstanceWarmup":
            return Optional.ofNullable(clazz.cast(instanceWarmup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RefreshPreferences, T> g) {
        return obj -> g.apply((RefreshPreferences) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RefreshPreferences> {
        /**
         * <p>
         * The amount of capacity in the Auto Scaling group that must remain healthy during an instance refresh to allow
         * the operation to continue, as a percentage of the desired capacity of the Auto Scaling group (rounded up to
         * the nearest integer). The default is <code>90</code>.
         * </p>
         * 
         * @param minHealthyPercentage
         *        The amount of capacity in the Auto Scaling group that must remain healthy during an instance refresh
         *        to allow the operation to continue, as a percentage of the desired capacity of the Auto Scaling group
         *        (rounded up to the nearest integer). The default is <code>90</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minHealthyPercentage(Integer minHealthyPercentage);

        /**
         * <p>
         * The number of seconds until a newly launched instance is configured and ready to use. During this time,
         * Amazon EC2 Auto Scaling does not immediately move on to the next replacement. The default is to use the value
         * for the health check grace period defined for the group.
         * </p>
         * 
         * @param instanceWarmup
         *        The number of seconds until a newly launched instance is configured and ready to use. During this
         *        time, Amazon EC2 Auto Scaling does not immediately move on to the next replacement. The default is to
         *        use the value for the health check grace period defined for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceWarmup(Integer instanceWarmup);
    }

    static final class BuilderImpl implements Builder {
        private Integer minHealthyPercentage;

        private Integer instanceWarmup;

        private BuilderImpl() {
        }

        private BuilderImpl(RefreshPreferences model) {
            minHealthyPercentage(model.minHealthyPercentage);
            instanceWarmup(model.instanceWarmup);
        }

        public final Integer getMinHealthyPercentage() {
            return minHealthyPercentage;
        }

        @Override
        public final Builder minHealthyPercentage(Integer minHealthyPercentage) {
            this.minHealthyPercentage = minHealthyPercentage;
            return this;
        }

        public final void setMinHealthyPercentage(Integer minHealthyPercentage) {
            this.minHealthyPercentage = minHealthyPercentage;
        }

        public final Integer getInstanceWarmup() {
            return instanceWarmup;
        }

        @Override
        public final Builder instanceWarmup(Integer instanceWarmup) {
            this.instanceWarmup = instanceWarmup;
            return this;
        }

        public final void setInstanceWarmup(Integer instanceWarmup) {
            this.instanceWarmup = instanceWarmup;
        }

        @Override
        public RefreshPreferences build() {
            return new RefreshPreferences(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
