/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeNotificationConfigurationsResponse extends AutoScalingResponse implements
        ToCopyableBuilder<DescribeNotificationConfigurationsResponse.Builder, DescribeNotificationConfigurationsResponse> {
    private static final SdkField<List<NotificationConfiguration>> NOTIFICATION_CONFIGURATIONS_FIELD = SdkField
            .<List<NotificationConfiguration>> builder(MarshallingType.LIST)
            .memberName("NotificationConfigurations")
            .getter(getter(DescribeNotificationConfigurationsResponse::notificationConfigurations))
            .setter(setter(Builder::notificationConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NotificationConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(NotificationConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeNotificationConfigurationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NOTIFICATION_CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));

    private final List<NotificationConfiguration> notificationConfigurations;

    private final String nextToken;

    private DescribeNotificationConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.notificationConfigurations = builder.notificationConfigurations;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the NotificationConfigurations property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasNotificationConfigurations() {
        return notificationConfigurations != null && !(notificationConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The notification configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNotificationConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The notification configurations.
     */
    public final List<NotificationConfiguration> notificationConfigurations() {
        return notificationConfigurations;
    }

    /**
     * <p>
     * A string that indicates that the response contains more items than can be returned in a single response. To
     * receive additional items, specify this string for the <code>NextToken</code> value when requesting the next set
     * of items. This value is null when there are no more items to return.
     * </p>
     * 
     * @return A string that indicates that the response contains more items than can be returned in a single response.
     *         To receive additional items, specify this string for the <code>NextToken</code> value when requesting the
     *         next set of items. This value is null when there are no more items to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasNotificationConfigurations() ? notificationConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNotificationConfigurationsResponse)) {
            return false;
        }
        DescribeNotificationConfigurationsResponse other = (DescribeNotificationConfigurationsResponse) obj;
        return hasNotificationConfigurations() == other.hasNotificationConfigurations()
                && Objects.equals(notificationConfigurations(), other.notificationConfigurations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeNotificationConfigurationsResponse")
                .add("NotificationConfigurations", hasNotificationConfigurations() ? notificationConfigurations() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NotificationConfigurations":
            return Optional.ofNullable(clazz.cast(notificationConfigurations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNotificationConfigurationsResponse, T> g) {
        return obj -> g.apply((DescribeNotificationConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeNotificationConfigurationsResponse> {
        /**
         * <p>
         * The notification configurations.
         * </p>
         * 
         * @param notificationConfigurations
         *        The notification configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationConfigurations(Collection<NotificationConfiguration> notificationConfigurations);

        /**
         * <p>
         * The notification configurations.
         * </p>
         * 
         * @param notificationConfigurations
         *        The notification configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationConfigurations(NotificationConfiguration... notificationConfigurations);

        /**
         * <p>
         * The notification configurations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NotificationConfiguration>.Builder}
         * avoiding the need to create one manually via {@link List<NotificationConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NotificationConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #notificationConfigurations(List<NotificationConfiguration>)}.
         * 
         * @param notificationConfigurations
         *        a consumer that will call methods on {@link List<NotificationConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationConfigurations(List<NotificationConfiguration>)
         */
        Builder notificationConfigurations(Consumer<NotificationConfiguration.Builder>... notificationConfigurations);

        /**
         * <p>
         * A string that indicates that the response contains more items than can be returned in a single response. To
         * receive additional items, specify this string for the <code>NextToken</code> value when requesting the next
         * set of items. This value is null when there are no more items to return.
         * </p>
         * 
         * @param nextToken
         *        A string that indicates that the response contains more items than can be returned in a single
         *        response. To receive additional items, specify this string for the <code>NextToken</code> value when
         *        requesting the next set of items. This value is null when there are no more items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private List<NotificationConfiguration> notificationConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNotificationConfigurationsResponse model) {
            super(model);
            notificationConfigurations(model.notificationConfigurations);
            nextToken(model.nextToken);
        }

        public final Collection<NotificationConfiguration.Builder> getNotificationConfigurations() {
            if (notificationConfigurations instanceof SdkAutoConstructList) {
                return null;
            }
            return notificationConfigurations != null ? notificationConfigurations.stream()
                    .map(NotificationConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder notificationConfigurations(Collection<NotificationConfiguration> notificationConfigurations) {
            this.notificationConfigurations = NotificationConfigurationsCopier.copy(notificationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationConfigurations(NotificationConfiguration... notificationConfigurations) {
            notificationConfigurations(Arrays.asList(notificationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationConfigurations(Consumer<NotificationConfiguration.Builder>... notificationConfigurations) {
            notificationConfigurations(Stream.of(notificationConfigurations)
                    .map(c -> NotificationConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNotificationConfigurations(
                Collection<NotificationConfiguration.BuilderImpl> notificationConfigurations) {
            this.notificationConfigurations = NotificationConfigurationsCopier.copyFromBuilder(notificationConfigurations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeNotificationConfigurationsResponse build() {
            return new DescribeNotificationConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
