/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TerminateInstanceInAutoScalingGroupRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, TerminateInstanceInAutoScalingGroupRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(TerminateInstanceInAutoScalingGroupRequest.getter(TerminateInstanceInAutoScalingGroupRequest::instanceId)).setter(TerminateInstanceInAutoScalingGroupRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<Boolean> SHOULD_DECREMENT_DESIRED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ShouldDecrementDesiredCapacity").getter(TerminateInstanceInAutoScalingGroupRequest.getter(TerminateInstanceInAutoScalingGroupRequest::shouldDecrementDesiredCapacity)).setter(TerminateInstanceInAutoScalingGroupRequest.setter(Builder::shouldDecrementDesiredCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShouldDecrementDesiredCapacity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, SHOULD_DECREMENT_DESIRED_CAPACITY_FIELD));
    private final String instanceId;
    private final Boolean shouldDecrementDesiredCapacity;

    private TerminateInstanceInAutoScalingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.shouldDecrementDesiredCapacity = builder.shouldDecrementDesiredCapacity;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final Boolean shouldDecrementDesiredCapacity() {
        return this.shouldDecrementDesiredCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.shouldDecrementDesiredCapacity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateInstanceInAutoScalingGroupRequest)) {
            return false;
        }
        TerminateInstanceInAutoScalingGroupRequest other = (TerminateInstanceInAutoScalingGroupRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.shouldDecrementDesiredCapacity(), other.shouldDecrementDesiredCapacity());
    }

    public final String toString() {
        return ToString.builder((String)"TerminateInstanceInAutoScalingGroupRequest").add("InstanceId", (Object)this.instanceId()).add("ShouldDecrementDesiredCapacity", (Object)this.shouldDecrementDesiredCapacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "ShouldDecrementDesiredCapacity": {
                return Optional.ofNullable(clazz.cast(this.shouldDecrementDesiredCapacity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TerminateInstanceInAutoScalingGroupRequest, T> g) {
        return obj -> g.apply((TerminateInstanceInAutoScalingGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private Boolean shouldDecrementDesiredCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateInstanceInAutoScalingGroupRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.shouldDecrementDesiredCapacity(model.shouldDecrementDesiredCapacity);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Boolean getShouldDecrementDesiredCapacity() {
            return this.shouldDecrementDesiredCapacity;
        }

        @Override
        public final Builder shouldDecrementDesiredCapacity(Boolean shouldDecrementDesiredCapacity) {
            this.shouldDecrementDesiredCapacity = shouldDecrementDesiredCapacity;
            return this;
        }

        public final void setShouldDecrementDesiredCapacity(Boolean shouldDecrementDesiredCapacity) {
            this.shouldDecrementDesiredCapacity = shouldDecrementDesiredCapacity;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TerminateInstanceInAutoScalingGroupRequest build() {
            return new TerminateInstanceInAutoScalingGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TerminateInstanceInAutoScalingGroupRequest> {
        public Builder instanceId(String var1);

        public Builder shouldDecrementDesiredCapacity(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

