/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.services.autoscaling.model.LaunchConfigurationNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLaunchConfigurationsRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, DescribeLaunchConfigurationsRequest> {
    private static final SdkField<List<String>> LAUNCH_CONFIGURATION_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LaunchConfigurationNames").getter(DescribeLaunchConfigurationsRequest.getter(DescribeLaunchConfigurationsRequest::launchConfigurationNames)).setter(DescribeLaunchConfigurationsRequest.setter(Builder::launchConfigurationNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchConfigurationNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeLaunchConfigurationsRequest.getter(DescribeLaunchConfigurationsRequest::nextToken)).setter(DescribeLaunchConfigurationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRecords").getter(DescribeLaunchConfigurationsRequest.getter(DescribeLaunchConfigurationsRequest::maxRecords)).setter(DescribeLaunchConfigurationsRequest.setter(Builder::maxRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_CONFIGURATION_NAMES_FIELD, NEXT_TOKEN_FIELD, MAX_RECORDS_FIELD));
    private final List<String> launchConfigurationNames;
    private final String nextToken;
    private final Integer maxRecords;

    private DescribeLaunchConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.launchConfigurationNames = builder.launchConfigurationNames;
        this.nextToken = builder.nextToken;
        this.maxRecords = builder.maxRecords;
    }

    public boolean hasLaunchConfigurationNames() {
        return this.launchConfigurationNames != null && !(this.launchConfigurationNames instanceof SdkAutoConstructList);
    }

    public List<String> launchConfigurationNames() {
        return this.launchConfigurationNames;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.launchConfigurationNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLaunchConfigurationsRequest)) {
            return false;
        }
        DescribeLaunchConfigurationsRequest other = (DescribeLaunchConfigurationsRequest)((Object)obj);
        return Objects.equals(this.launchConfigurationNames(), other.launchConfigurationNames()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxRecords(), other.maxRecords());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLaunchConfigurationsRequest").add("LaunchConfigurationNames", this.launchConfigurationNames()).add("NextToken", (Object)this.nextToken()).add("MaxRecords", (Object)this.maxRecords()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchConfigurationNames": {
                return Optional.ofNullable(clazz.cast(this.launchConfigurationNames()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxRecords": {
                return Optional.ofNullable(clazz.cast(this.maxRecords()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLaunchConfigurationsRequest, T> g) {
        return obj -> g.apply((DescribeLaunchConfigurationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private List<String> launchConfigurationNames = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLaunchConfigurationsRequest model) {
            super(model);
            this.launchConfigurationNames(model.launchConfigurationNames);
            this.nextToken(model.nextToken);
            this.maxRecords(model.maxRecords);
        }

        public final Collection<String> getLaunchConfigurationNames() {
            return this.launchConfigurationNames;
        }

        @Override
        public final Builder launchConfigurationNames(Collection<String> launchConfigurationNames) {
            this.launchConfigurationNames = LaunchConfigurationNamesCopier.copy(launchConfigurationNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchConfigurationNames(String ... launchConfigurationNames) {
            this.launchConfigurationNames(Arrays.asList(launchConfigurationNames));
            return this;
        }

        public final void setLaunchConfigurationNames(Collection<String> launchConfigurationNames) {
            this.launchConfigurationNames = LaunchConfigurationNamesCopier.copy(launchConfigurationNames);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeLaunchConfigurationsRequest build() {
            return new DescribeLaunchConfigurationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLaunchConfigurationsRequest> {
        public Builder launchConfigurationNames(Collection<String> var1);

        public Builder launchConfigurationNames(String ... var1);

        public Builder nextToken(String var1);

        public Builder maxRecords(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

