/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingNotificationTypesCopier;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLifecycleHookTypesResponse
extends AutoScalingResponse
implements ToCopyableBuilder<Builder, DescribeLifecycleHookTypesResponse> {
    private static final SdkField<List<String>> LIFECYCLE_HOOK_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LifecycleHookTypes").getter(DescribeLifecycleHookTypesResponse.getter(DescribeLifecycleHookTypesResponse::lifecycleHookTypes)).setter(DescribeLifecycleHookTypesResponse.setter(Builder::lifecycleHookTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleHookTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_HOOK_TYPES_FIELD));
    private final List<String> lifecycleHookTypes;

    private DescribeLifecycleHookTypesResponse(BuilderImpl builder) {
        super(builder);
        this.lifecycleHookTypes = builder.lifecycleHookTypes;
    }

    public boolean hasLifecycleHookTypes() {
        return this.lifecycleHookTypes != null && !(this.lifecycleHookTypes instanceof SdkAutoConstructList);
    }

    public List<String> lifecycleHookTypes() {
        return this.lifecycleHookTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleHookTypes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLifecycleHookTypesResponse)) {
            return false;
        }
        DescribeLifecycleHookTypesResponse other = (DescribeLifecycleHookTypesResponse)((Object)obj);
        return Objects.equals(this.lifecycleHookTypes(), other.lifecycleHookTypes());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLifecycleHookTypesResponse").add("LifecycleHookTypes", this.lifecycleHookTypes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LifecycleHookTypes": {
                return Optional.ofNullable(clazz.cast(this.lifecycleHookTypes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLifecycleHookTypesResponse, T> g) {
        return obj -> g.apply((DescribeLifecycleHookTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingResponse.BuilderImpl
    implements Builder {
        private List<String> lifecycleHookTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLifecycleHookTypesResponse model) {
            super(model);
            this.lifecycleHookTypes(model.lifecycleHookTypes);
        }

        public final Collection<String> getLifecycleHookTypes() {
            return this.lifecycleHookTypes;
        }

        @Override
        public final Builder lifecycleHookTypes(Collection<String> lifecycleHookTypes) {
            this.lifecycleHookTypes = AutoScalingNotificationTypesCopier.copy(lifecycleHookTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleHookTypes(String ... lifecycleHookTypes) {
            this.lifecycleHookTypes(Arrays.asList(lifecycleHookTypes));
            return this;
        }

        public final void setLifecycleHookTypes(Collection<String> lifecycleHookTypes) {
            this.lifecycleHookTypes = AutoScalingNotificationTypesCopier.copy(lifecycleHookTypes);
        }

        @Override
        public DescribeLifecycleHookTypesResponse build() {
            return new DescribeLifecycleHookTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLifecycleHookTypesResponse> {
        public Builder lifecycleHookTypes(Collection<String> var1);

        public Builder lifecycleHookTypes(String ... var1);
    }
}

