/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotificationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NotificationConfiguration> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NotificationConfiguration.getter(NotificationConfiguration::autoScalingGroupName)).setter(NotificationConfiguration.setter(Builder::autoScalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build()}).build();
    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NotificationConfiguration.getter(NotificationConfiguration::topicARN)).setter(NotificationConfiguration.setter(Builder::topicARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicARN").build()}).build();
    private static final SdkField<String> NOTIFICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NotificationConfiguration.getter(NotificationConfiguration::notificationType)).setter(NotificationConfiguration.setter(Builder::notificationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD, TOPIC_ARN_FIELD, NOTIFICATION_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String autoScalingGroupName;
    private final String topicARN;
    private final String notificationType;

    private NotificationConfiguration(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.topicARN = builder.topicARN;
        this.notificationType = builder.notificationType;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public String topicARN() {
        return this.topicARN;
    }

    public String notificationType() {
        return this.notificationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationConfiguration)) {
            return false;
        }
        NotificationConfiguration other = (NotificationConfiguration)obj;
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.topicARN(), other.topicARN()) && Objects.equals(this.notificationType(), other.notificationType());
    }

    public String toString() {
        return ToString.builder((String)"NotificationConfiguration").add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("TopicARN", (Object)this.topicARN()).add("NotificationType", (Object)this.notificationType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "TopicARN": {
                return Optional.ofNullable(clazz.cast(this.topicARN()));
            }
            case "NotificationType": {
                return Optional.ofNullable(clazz.cast(this.notificationType()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotificationConfiguration, T> g) {
        return obj -> g.apply((NotificationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private String topicARN;
        private String notificationType;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationConfiguration model) {
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.topicARN(model.topicARN);
            this.notificationType(model.notificationType);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getTopicARN() {
            return this.topicARN;
        }

        @Override
        public final Builder topicARN(String topicARN) {
            this.topicARN = topicARN;
            return this;
        }

        public final void setTopicARN(String topicARN) {
            this.topicARN = topicARN;
        }

        public final String getNotificationType() {
            return this.notificationType;
        }

        @Override
        public final Builder notificationType(String notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        public final void setNotificationType(String notificationType) {
            this.notificationType = notificationType;
        }

        public NotificationConfiguration build() {
            return new NotificationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NotificationConfiguration> {
        public Builder autoScalingGroupName(String var1);

        public Builder topicARN(String var1);

        public Builder notificationType(String var1);
    }
}

