/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LifecycleHook
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LifecycleHook> {
    private static final SdkField<String> LIFECYCLE_HOOK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LifecycleHook.getter(LifecycleHook::lifecycleHookName)).setter(LifecycleHook.setter(Builder::lifecycleHookName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleHookName").build()}).build();
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LifecycleHook.getter(LifecycleHook::autoScalingGroupName)).setter(LifecycleHook.setter(Builder::autoScalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build()}).build();
    private static final SdkField<String> LIFECYCLE_TRANSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LifecycleHook.getter(LifecycleHook::lifecycleTransition)).setter(LifecycleHook.setter(Builder::lifecycleTransition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleTransition").build()}).build();
    private static final SdkField<String> NOTIFICATION_TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LifecycleHook.getter(LifecycleHook::notificationTargetARN)).setter(LifecycleHook.setter(Builder::notificationTargetARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationTargetARN").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LifecycleHook.getter(LifecycleHook::roleARN)).setter(LifecycleHook.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<String> NOTIFICATION_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LifecycleHook.getter(LifecycleHook::notificationMetadata)).setter(LifecycleHook.setter(Builder::notificationMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationMetadata").build()}).build();
    private static final SdkField<Integer> HEARTBEAT_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(LifecycleHook.getter(LifecycleHook::heartbeatTimeout)).setter(LifecycleHook.setter(Builder::heartbeatTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeartbeatTimeout").build()}).build();
    private static final SdkField<Integer> GLOBAL_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(LifecycleHook.getter(LifecycleHook::globalTimeout)).setter(LifecycleHook.setter(Builder::globalTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalTimeout").build()}).build();
    private static final SdkField<String> DEFAULT_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LifecycleHook.getter(LifecycleHook::defaultResult)).setter(LifecycleHook.setter(Builder::defaultResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultResult").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_HOOK_NAME_FIELD, AUTO_SCALING_GROUP_NAME_FIELD, LIFECYCLE_TRANSITION_FIELD, NOTIFICATION_TARGET_ARN_FIELD, ROLE_ARN_FIELD, NOTIFICATION_METADATA_FIELD, HEARTBEAT_TIMEOUT_FIELD, GLOBAL_TIMEOUT_FIELD, DEFAULT_RESULT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String lifecycleHookName;
    private final String autoScalingGroupName;
    private final String lifecycleTransition;
    private final String notificationTargetARN;
    private final String roleARN;
    private final String notificationMetadata;
    private final Integer heartbeatTimeout;
    private final Integer globalTimeout;
    private final String defaultResult;

    private LifecycleHook(BuilderImpl builder) {
        this.lifecycleHookName = builder.lifecycleHookName;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.lifecycleTransition = builder.lifecycleTransition;
        this.notificationTargetARN = builder.notificationTargetARN;
        this.roleARN = builder.roleARN;
        this.notificationMetadata = builder.notificationMetadata;
        this.heartbeatTimeout = builder.heartbeatTimeout;
        this.globalTimeout = builder.globalTimeout;
        this.defaultResult = builder.defaultResult;
    }

    public String lifecycleHookName() {
        return this.lifecycleHookName;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public String lifecycleTransition() {
        return this.lifecycleTransition;
    }

    public String notificationTargetARN() {
        return this.notificationTargetARN;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public String notificationMetadata() {
        return this.notificationMetadata;
    }

    public Integer heartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    public Integer globalTimeout() {
        return this.globalTimeout;
    }

    public String defaultResult() {
        return this.defaultResult;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleHookName());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleTransition());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationTargetARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.heartbeatTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultResult());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecycleHook)) {
            return false;
        }
        LifecycleHook other = (LifecycleHook)obj;
        return Objects.equals(this.lifecycleHookName(), other.lifecycleHookName()) && Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.lifecycleTransition(), other.lifecycleTransition()) && Objects.equals(this.notificationTargetARN(), other.notificationTargetARN()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.notificationMetadata(), other.notificationMetadata()) && Objects.equals(this.heartbeatTimeout(), other.heartbeatTimeout()) && Objects.equals(this.globalTimeout(), other.globalTimeout()) && Objects.equals(this.defaultResult(), other.defaultResult());
    }

    public String toString() {
        return ToString.builder((String)"LifecycleHook").add("LifecycleHookName", (Object)this.lifecycleHookName()).add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("LifecycleTransition", (Object)this.lifecycleTransition()).add("NotificationTargetARN", (Object)this.notificationTargetARN()).add("RoleARN", (Object)this.roleARN()).add("NotificationMetadata", (Object)this.notificationMetadata()).add("HeartbeatTimeout", (Object)this.heartbeatTimeout()).add("GlobalTimeout", (Object)this.globalTimeout()).add("DefaultResult", (Object)this.defaultResult()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LifecycleHookName": {
                return Optional.ofNullable(clazz.cast(this.lifecycleHookName()));
            }
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "LifecycleTransition": {
                return Optional.ofNullable(clazz.cast(this.lifecycleTransition()));
            }
            case "NotificationTargetARN": {
                return Optional.ofNullable(clazz.cast(this.notificationTargetARN()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "NotificationMetadata": {
                return Optional.ofNullable(clazz.cast(this.notificationMetadata()));
            }
            case "HeartbeatTimeout": {
                return Optional.ofNullable(clazz.cast(this.heartbeatTimeout()));
            }
            case "GlobalTimeout": {
                return Optional.ofNullable(clazz.cast(this.globalTimeout()));
            }
            case "DefaultResult": {
                return Optional.ofNullable(clazz.cast(this.defaultResult()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LifecycleHook, T> g) {
        return obj -> g.apply((LifecycleHook)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String lifecycleHookName;
        private String autoScalingGroupName;
        private String lifecycleTransition;
        private String notificationTargetARN;
        private String roleARN;
        private String notificationMetadata;
        private Integer heartbeatTimeout;
        private Integer globalTimeout;
        private String defaultResult;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecycleHook model) {
            this.lifecycleHookName(model.lifecycleHookName);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.lifecycleTransition(model.lifecycleTransition);
            this.notificationTargetARN(model.notificationTargetARN);
            this.roleARN(model.roleARN);
            this.notificationMetadata(model.notificationMetadata);
            this.heartbeatTimeout(model.heartbeatTimeout);
            this.globalTimeout(model.globalTimeout);
            this.defaultResult(model.defaultResult);
        }

        public final String getLifecycleHookName() {
            return this.lifecycleHookName;
        }

        @Override
        public final Builder lifecycleHookName(String lifecycleHookName) {
            this.lifecycleHookName = lifecycleHookName;
            return this;
        }

        public final void setLifecycleHookName(String lifecycleHookName) {
            this.lifecycleHookName = lifecycleHookName;
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getLifecycleTransition() {
            return this.lifecycleTransition;
        }

        @Override
        public final Builder lifecycleTransition(String lifecycleTransition) {
            this.lifecycleTransition = lifecycleTransition;
            return this;
        }

        public final void setLifecycleTransition(String lifecycleTransition) {
            this.lifecycleTransition = lifecycleTransition;
        }

        public final String getNotificationTargetARN() {
            return this.notificationTargetARN;
        }

        @Override
        public final Builder notificationTargetARN(String notificationTargetARN) {
            this.notificationTargetARN = notificationTargetARN;
            return this;
        }

        public final void setNotificationTargetARN(String notificationTargetARN) {
            this.notificationTargetARN = notificationTargetARN;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getNotificationMetadata() {
            return this.notificationMetadata;
        }

        @Override
        public final Builder notificationMetadata(String notificationMetadata) {
            this.notificationMetadata = notificationMetadata;
            return this;
        }

        public final void setNotificationMetadata(String notificationMetadata) {
            this.notificationMetadata = notificationMetadata;
        }

        public final Integer getHeartbeatTimeout() {
            return this.heartbeatTimeout;
        }

        @Override
        public final Builder heartbeatTimeout(Integer heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
            return this;
        }

        public final void setHeartbeatTimeout(Integer heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
        }

        public final Integer getGlobalTimeout() {
            return this.globalTimeout;
        }

        @Override
        public final Builder globalTimeout(Integer globalTimeout) {
            this.globalTimeout = globalTimeout;
            return this;
        }

        public final void setGlobalTimeout(Integer globalTimeout) {
            this.globalTimeout = globalTimeout;
        }

        public final String getDefaultResult() {
            return this.defaultResult;
        }

        @Override
        public final Builder defaultResult(String defaultResult) {
            this.defaultResult = defaultResult;
            return this;
        }

        public final void setDefaultResult(String defaultResult) {
            this.defaultResult = defaultResult;
        }

        public LifecycleHook build() {
            return new LifecycleHook(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LifecycleHook> {
        public Builder lifecycleHookName(String var1);

        public Builder autoScalingGroupName(String var1);

        public Builder lifecycleTransition(String var1);

        public Builder notificationTargetARN(String var1);

        public Builder roleARN(String var1);

        public Builder notificationMetadata(String var1);

        public Builder heartbeatTimeout(Integer var1);

        public Builder globalTimeout(Integer var1);

        public Builder defaultResult(String var1);
    }
}

