/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an override for a launch template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchTemplateOverrides implements SdkPojo, Serializable,
        ToCopyableBuilder<LaunchTemplateOverrides.Builder, LaunchTemplateOverrides> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LaunchTemplateOverrides::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> WEIGHTED_CAPACITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LaunchTemplateOverrides::weightedCapacity)).setter(setter(Builder::weightedCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeightedCapacity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD,
            WEIGHTED_CAPACITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceType;

    private final String weightedCapacity;

    private LaunchTemplateOverrides(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.weightedCapacity = builder.weightedCapacity;
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * <p>
     * For information about available instance types, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes">Available
     * Instance Types</a> in the <i>Amazon Elastic Compute Cloud User Guide.</i>
     * </p>
     * 
     * @return The instance type.</p>
     *         <p>
     *         For information about available instance types, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes"
     *         >Available Instance Types</a> in the <i>Amazon Elastic Compute Cloud User Guide.</i>
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The number of capacity units, which gives the instance type a proportional weight to other instance types. For
     * example, larger instance types are generally weighted more than smaller instance types. These are the same units
     * that you chose to set the desired capacity in terms of instances, or a performance attribute such as vCPUs,
     * memory, or I/O.
     * </p>
     * <p>
     * Valid Range: Minimum value of 1. Maximum value of 999.
     * </p>
     * 
     * @return The number of capacity units, which gives the instance type a proportional weight to other instance
     *         types. For example, larger instance types are generally weighted more than smaller instance types. These
     *         are the same units that you chose to set the desired capacity in terms of instances, or a performance
     *         attribute such as vCPUs, memory, or I/O.</p>
     *         <p>
     *         Valid Range: Minimum value of 1. Maximum value of 999.
     */
    public String weightedCapacity() {
        return weightedCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(weightedCapacity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateOverrides)) {
            return false;
        }
        LaunchTemplateOverrides other = (LaunchTemplateOverrides) obj;
        return Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(weightedCapacity(), other.weightedCapacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LaunchTemplateOverrides").add("InstanceType", instanceType())
                .add("WeightedCapacity", weightedCapacity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "WeightedCapacity":
            return Optional.ofNullable(clazz.cast(weightedCapacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplateOverrides, T> g) {
        return obj -> g.apply((LaunchTemplateOverrides) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LaunchTemplateOverrides> {
        /**
         * <p>
         * The instance type.
         * </p>
         * <p>
         * For information about available instance types, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes"
         * >Available Instance Types</a> in the <i>Amazon Elastic Compute Cloud User Guide.</i>
         * </p>
         * 
         * @param instanceType
         *        The instance type.</p>
         *        <p>
         *        For information about available instance types, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes"
         *        >Available Instance Types</a> in the <i>Amazon Elastic Compute Cloud User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The number of capacity units, which gives the instance type a proportional weight to other instance types.
         * For example, larger instance types are generally weighted more than smaller instance types. These are the
         * same units that you chose to set the desired capacity in terms of instances, or a performance attribute such
         * as vCPUs, memory, or I/O.
         * </p>
         * <p>
         * Valid Range: Minimum value of 1. Maximum value of 999.
         * </p>
         * 
         * @param weightedCapacity
         *        The number of capacity units, which gives the instance type a proportional weight to other instance
         *        types. For example, larger instance types are generally weighted more than smaller instance types.
         *        These are the same units that you chose to set the desired capacity in terms of instances, or a
         *        performance attribute such as vCPUs, memory, or I/O.</p>
         *        <p>
         *        Valid Range: Minimum value of 1. Maximum value of 999.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weightedCapacity(String weightedCapacity);
    }

    static final class BuilderImpl implements Builder {
        private String instanceType;

        private String weightedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateOverrides model) {
            instanceType(model.instanceType);
            weightedCapacity(model.weightedCapacity);
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getWeightedCapacity() {
            return weightedCapacity;
        }

        @Override
        public final Builder weightedCapacity(String weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
            return this;
        }

        public final void setWeightedCapacity(String weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
        }

        @Override
        public LaunchTemplateOverrides build() {
            return new LaunchTemplateOverrides(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
