/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingResponse;
import software.amazon.awssdk.services.autoscaling.model.LifecycleHook;
import software.amazon.awssdk.services.autoscaling.model.LifecycleHooksCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLifecycleHooksResponse
extends AutoScalingResponse
implements ToCopyableBuilder<Builder, DescribeLifecycleHooksResponse> {
    private static final SdkField<List<LifecycleHook>> LIFECYCLE_HOOKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeLifecycleHooksResponse.getter(DescribeLifecycleHooksResponse::lifecycleHooks)).setter(DescribeLifecycleHooksResponse.setter(Builder::lifecycleHooks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleHooks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LifecycleHook::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_HOOKS_FIELD));
    private final List<LifecycleHook> lifecycleHooks;

    private DescribeLifecycleHooksResponse(BuilderImpl builder) {
        super(builder);
        this.lifecycleHooks = builder.lifecycleHooks;
    }

    public boolean hasLifecycleHooks() {
        return this.lifecycleHooks != null && !(this.lifecycleHooks instanceof SdkAutoConstructList);
    }

    public List<LifecycleHook> lifecycleHooks() {
        return this.lifecycleHooks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleHooks());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLifecycleHooksResponse)) {
            return false;
        }
        DescribeLifecycleHooksResponse other = (DescribeLifecycleHooksResponse)((Object)obj);
        return Objects.equals(this.lifecycleHooks(), other.lifecycleHooks());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLifecycleHooksResponse").add("LifecycleHooks", this.lifecycleHooks()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LifecycleHooks": {
                return Optional.ofNullable(clazz.cast(this.lifecycleHooks()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLifecycleHooksResponse, T> g) {
        return obj -> g.apply((DescribeLifecycleHooksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingResponse.BuilderImpl
    implements Builder {
        private List<LifecycleHook> lifecycleHooks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLifecycleHooksResponse model) {
            super(model);
            this.lifecycleHooks(model.lifecycleHooks);
        }

        public final Collection<LifecycleHook.Builder> getLifecycleHooks() {
            return this.lifecycleHooks != null ? (Collection)this.lifecycleHooks.stream().map(LifecycleHook::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lifecycleHooks(Collection<LifecycleHook> lifecycleHooks) {
            this.lifecycleHooks = LifecycleHooksCopier.copy(lifecycleHooks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleHooks(LifecycleHook ... lifecycleHooks) {
            this.lifecycleHooks(Arrays.asList(lifecycleHooks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleHooks(Consumer<LifecycleHook.Builder> ... lifecycleHooks) {
            this.lifecycleHooks(Stream.of(lifecycleHooks).map(c -> (LifecycleHook)((LifecycleHook.Builder)LifecycleHook.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLifecycleHooks(Collection<LifecycleHook.BuilderImpl> lifecycleHooks) {
            this.lifecycleHooks = LifecycleHooksCopier.copyFromBuilder(lifecycleHooks);
        }

        @Override
        public DescribeLifecycleHooksResponse build() {
            return new DescribeLifecycleHooksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLifecycleHooksResponse> {
        public Builder lifecycleHooks(Collection<LifecycleHook> var1);

        public Builder lifecycleHooks(LifecycleHook ... var1);

        public Builder lifecycleHooks(Consumer<LifecycleHook.Builder> ... var1);
    }
}

