/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetDesiredCapacityRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, SetDesiredCapacityRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SetDesiredCapacityRequest.getter(SetDesiredCapacityRequest::autoScalingGroupName)).setter(SetDesiredCapacityRequest.setter(Builder::autoScalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build()}).build();
    private static final SdkField<Integer> DESIRED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(SetDesiredCapacityRequest.getter(SetDesiredCapacityRequest::desiredCapacity)).setter(SetDesiredCapacityRequest.setter(Builder::desiredCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredCapacity").build()}).build();
    private static final SdkField<Boolean> HONOR_COOLDOWN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(SetDesiredCapacityRequest.getter(SetDesiredCapacityRequest::honorCooldown)).setter(SetDesiredCapacityRequest.setter(Builder::honorCooldown)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HonorCooldown").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD, DESIRED_CAPACITY_FIELD, HONOR_COOLDOWN_FIELD));
    private final String autoScalingGroupName;
    private final Integer desiredCapacity;
    private final Boolean honorCooldown;

    private SetDesiredCapacityRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.desiredCapacity = builder.desiredCapacity;
        this.honorCooldown = builder.honorCooldown;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public Integer desiredCapacity() {
        return this.desiredCapacity;
    }

    public Boolean honorCooldown() {
        return this.honorCooldown;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.honorCooldown());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetDesiredCapacityRequest)) {
            return false;
        }
        SetDesiredCapacityRequest other = (SetDesiredCapacityRequest)((Object)obj);
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.desiredCapacity(), other.desiredCapacity()) && Objects.equals(this.honorCooldown(), other.honorCooldown());
    }

    public String toString() {
        return ToString.builder((String)"SetDesiredCapacityRequest").add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("DesiredCapacity", (Object)this.desiredCapacity()).add("HonorCooldown", (Object)this.honorCooldown()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "DesiredCapacity": {
                return Optional.ofNullable(clazz.cast(this.desiredCapacity()));
            }
            case "HonorCooldown": {
                return Optional.ofNullable(clazz.cast(this.honorCooldown()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetDesiredCapacityRequest, T> g) {
        return obj -> g.apply((SetDesiredCapacityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private Integer desiredCapacity;
        private Boolean honorCooldown;

        private BuilderImpl() {
        }

        private BuilderImpl(SetDesiredCapacityRequest model) {
            super(model);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.desiredCapacity(model.desiredCapacity);
            this.honorCooldown(model.honorCooldown);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Integer getDesiredCapacity() {
            return this.desiredCapacity;
        }

        @Override
        public final Builder desiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public final void setDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
        }

        public final Boolean getHonorCooldown() {
            return this.honorCooldown;
        }

        @Override
        public final Builder honorCooldown(Boolean honorCooldown) {
            this.honorCooldown = honorCooldown;
            return this;
        }

        public final void setHonorCooldown(Boolean honorCooldown) {
            this.honorCooldown = honorCooldown;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetDesiredCapacityRequest build() {
            return new SetDesiredCapacityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SetDesiredCapacityRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder desiredCapacity(Integer var1);

        public Builder honorCooldown(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

