/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.autoscaling.AutoScalingAsyncClient;
import software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsResponse;
import software.amazon.awssdk.services.autoscaling.model.ScheduledUpdateGroupAction;

public class DescribeScheduledActionsPublisher
implements SdkPublisher<DescribeScheduledActionsResponse> {
    private final AutoScalingAsyncClient client;
    private final DescribeScheduledActionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeScheduledActionsPublisher(AutoScalingAsyncClient client, DescribeScheduledActionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeScheduledActionsPublisher(AutoScalingAsyncClient client, DescribeScheduledActionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeScheduledActionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeScheduledActionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<ScheduledUpdateGroupAction> scheduledUpdateGroupActions() {
        Function<DescribeScheduledActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.scheduledUpdateGroupActions() != null) {
                return response.scheduledUpdateGroupActions().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeScheduledActionsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeScheduledActionsPublisher resume(DescribeScheduledActionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeScheduledActionsPublisher(this.client, (DescribeScheduledActionsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeScheduledActionsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeScheduledActionsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeScheduledActionsResponseFetcher
    implements AsyncPageFetcher<DescribeScheduledActionsResponse> {
        private DescribeScheduledActionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeScheduledActionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<DescribeScheduledActionsResponse> nextPage(DescribeScheduledActionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeScheduledActionsPublisher.this.client.describeScheduledActions(DescribeScheduledActionsPublisher.this.firstRequest);
            }
            return DescribeScheduledActionsPublisher.this.client.describeScheduledActions((DescribeScheduledActionsRequest)((Object)DescribeScheduledActionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

