/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.services.autoscaling.model.ProcessNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResumeProcessesRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, ResumeProcessesRequest> {
    private final String autoScalingGroupName;
    private final List<String> scalingProcesses;

    private ResumeProcessesRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.scalingProcesses = builder.scalingProcesses;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public List<String> scalingProcesses() {
        return this.scalingProcesses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingProcesses());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResumeProcessesRequest)) {
            return false;
        }
        ResumeProcessesRequest other = (ResumeProcessesRequest)((Object)obj);
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.scalingProcesses(), other.scalingProcesses());
    }

    public String toString() {
        return ToString.builder((String)"ResumeProcessesRequest").add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("ScalingProcesses", this.scalingProcesses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.of(clazz.cast(this.autoScalingGroupName()));
            }
            case "ScalingProcesses": {
                return Optional.of(clazz.cast(this.scalingProcesses()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private List<String> scalingProcesses;

        private BuilderImpl() {
        }

        private BuilderImpl(ResumeProcessesRequest model) {
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.scalingProcesses(model.scalingProcesses);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Collection<String> getScalingProcesses() {
            return this.scalingProcesses;
        }

        @Override
        public final Builder scalingProcesses(Collection<String> scalingProcesses) {
            this.scalingProcesses = ProcessNamesCopier.copy(scalingProcesses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingProcesses(String ... scalingProcesses) {
            this.scalingProcesses(Arrays.asList(scalingProcesses));
            return this;
        }

        public final void setScalingProcesses(Collection<String> scalingProcesses) {
            this.scalingProcesses = ProcessNamesCopier.copy(scalingProcesses);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ResumeProcessesRequest build() {
            return new ResumeProcessesRequest(this);
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    CopyableBuilder<Builder, ResumeProcessesRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder scalingProcesses(Collection<String> var1);

        public Builder scalingProcesses(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

