/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ExecutePolicyRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, ExecutePolicyRequest> {
    private final String autoScalingGroupName;
    private final String policyName;
    private final Boolean honorCooldown;
    private final Double metricValue;
    private final Double breachThreshold;

    private ExecutePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.policyName = builder.policyName;
        this.honorCooldown = builder.honorCooldown;
        this.metricValue = builder.metricValue;
        this.breachThreshold = builder.breachThreshold;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public String policyName() {
        return this.policyName;
    }

    public Boolean honorCooldown() {
        return this.honorCooldown;
    }

    public Double metricValue() {
        return this.metricValue;
    }

    public Double breachThreshold() {
        return this.breachThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.honorCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.breachThreshold());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutePolicyRequest)) {
            return false;
        }
        ExecutePolicyRequest other = (ExecutePolicyRequest)((Object)obj);
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.honorCooldown(), other.honorCooldown()) && Objects.equals(this.metricValue(), other.metricValue()) && Objects.equals(this.breachThreshold(), other.breachThreshold());
    }

    public String toString() {
        return ToString.builder((String)"ExecutePolicyRequest").add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("PolicyName", (Object)this.policyName()).add("HonorCooldown", (Object)this.honorCooldown()).add("MetricValue", (Object)this.metricValue()).add("BreachThreshold", (Object)this.breachThreshold()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.of(clazz.cast(this.autoScalingGroupName()));
            }
            case "PolicyName": {
                return Optional.of(clazz.cast(this.policyName()));
            }
            case "HonorCooldown": {
                return Optional.of(clazz.cast(this.honorCooldown()));
            }
            case "MetricValue": {
                return Optional.of(clazz.cast(this.metricValue()));
            }
            case "BreachThreshold": {
                return Optional.of(clazz.cast(this.breachThreshold()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private String policyName;
        private Boolean honorCooldown;
        private Double metricValue;
        private Double breachThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutePolicyRequest model) {
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.policyName(model.policyName);
            this.honorCooldown(model.honorCooldown);
            this.metricValue(model.metricValue);
            this.breachThreshold(model.breachThreshold);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final Boolean getHonorCooldown() {
            return this.honorCooldown;
        }

        @Override
        public final Builder honorCooldown(Boolean honorCooldown) {
            this.honorCooldown = honorCooldown;
            return this;
        }

        public final void setHonorCooldown(Boolean honorCooldown) {
            this.honorCooldown = honorCooldown;
        }

        public final Double getMetricValue() {
            return this.metricValue;
        }

        @Override
        public final Builder metricValue(Double metricValue) {
            this.metricValue = metricValue;
            return this;
        }

        public final void setMetricValue(Double metricValue) {
            this.metricValue = metricValue;
        }

        public final Double getBreachThreshold() {
            return this.breachThreshold;
        }

        @Override
        public final Builder breachThreshold(Double breachThreshold) {
            this.breachThreshold = breachThreshold;
            return this;
        }

        public final void setBreachThreshold(Double breachThreshold) {
            this.breachThreshold = breachThreshold;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ExecutePolicyRequest build() {
            return new ExecutePolicyRequest(this);
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    CopyableBuilder<Builder, ExecutePolicyRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder policyName(String var1);

        public Builder honorCooldown(Boolean var1);

        public Builder metricValue(Double var1);

        public Builder breachThreshold(Double var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

