/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteNotificationConfigurationRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, DeleteNotificationConfigurationRequest> {
    private final String autoScalingGroupName;
    private final String topicARN;

    private DeleteNotificationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.topicARN = builder.topicARN;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public String topicARN() {
        return this.topicARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicARN());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteNotificationConfigurationRequest)) {
            return false;
        }
        DeleteNotificationConfigurationRequest other = (DeleteNotificationConfigurationRequest)((Object)obj);
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.topicARN(), other.topicARN());
    }

    public String toString() {
        return ToString.builder((String)"DeleteNotificationConfigurationRequest").add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("TopicARN", (Object)this.topicARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.of(clazz.cast(this.autoScalingGroupName()));
            }
            case "TopicARN": {
                return Optional.of(clazz.cast(this.topicARN()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private String topicARN;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteNotificationConfigurationRequest model) {
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.topicARN(model.topicARN);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getTopicARN() {
            return this.topicARN;
        }

        @Override
        public final Builder topicARN(String topicARN) {
            this.topicARN = topicARN;
            return this;
        }

        public final void setTopicARN(String topicARN) {
            this.topicARN = topicARN;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteNotificationConfigurationRequest build() {
            return new DeleteNotificationConfigurationRequest(this);
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    CopyableBuilder<Builder, DeleteNotificationConfigurationRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder topicARN(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

