/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.autoscaling.model.ResumeProcessesRequest;
import software.amazon.awssdk.util.StringUtils;

public class ResumeProcessesRequestMarshaller
implements Marshaller<Request<ResumeProcessesRequest>, ResumeProcessesRequest> {
    public Request<ResumeProcessesRequest> marshall(ResumeProcessesRequest resumeProcessesRequest) {
        List<String> scalingProcessesList;
        if (resumeProcessesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)resumeProcessesRequest, "AutoScalingClient");
        request.addParameter("Action", "ResumeProcesses");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (resumeProcessesRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)resumeProcessesRequest.autoScalingGroupName()));
        }
        if ((scalingProcessesList = resumeProcessesRequest.scalingProcesses()) != null) {
            if (!scalingProcessesList.isEmpty()) {
                int scalingProcessesListIndex = 1;
                for (String scalingProcessesListValue : scalingProcessesList) {
                    if (scalingProcessesListValue != null) {
                        request.addParameter("ScalingProcesses.member." + scalingProcessesListIndex, StringUtils.fromString((String)scalingProcessesListValue));
                    }
                    ++scalingProcessesListIndex;
                }
            } else {
                request.addParameter("ScalingProcesses", "");
            }
        }
        return request;
    }
}

