/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.time.Instant;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.autoscaling.model.PutScheduledUpdateGroupActionRequest;
import software.amazon.awssdk.util.StringUtils;

public class PutScheduledUpdateGroupActionRequestMarshaller
implements Marshaller<Request<PutScheduledUpdateGroupActionRequest>, PutScheduledUpdateGroupActionRequest> {
    public Request<PutScheduledUpdateGroupActionRequest> marshall(PutScheduledUpdateGroupActionRequest putScheduledUpdateGroupActionRequest) {
        if (putScheduledUpdateGroupActionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putScheduledUpdateGroupActionRequest, "AutoScalingClient");
        request.addParameter("Action", "PutScheduledUpdateGroupAction");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putScheduledUpdateGroupActionRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)putScheduledUpdateGroupActionRequest.autoScalingGroupName()));
        }
        if (putScheduledUpdateGroupActionRequest.scheduledActionName() != null) {
            request.addParameter("ScheduledActionName", StringUtils.fromString((String)putScheduledUpdateGroupActionRequest.scheduledActionName()));
        }
        if (putScheduledUpdateGroupActionRequest.time() != null) {
            request.addParameter("Time", StringUtils.fromInstant((Instant)putScheduledUpdateGroupActionRequest.time()));
        }
        if (putScheduledUpdateGroupActionRequest.startTime() != null) {
            request.addParameter("StartTime", StringUtils.fromInstant((Instant)putScheduledUpdateGroupActionRequest.startTime()));
        }
        if (putScheduledUpdateGroupActionRequest.endTime() != null) {
            request.addParameter("EndTime", StringUtils.fromInstant((Instant)putScheduledUpdateGroupActionRequest.endTime()));
        }
        if (putScheduledUpdateGroupActionRequest.recurrence() != null) {
            request.addParameter("Recurrence", StringUtils.fromString((String)putScheduledUpdateGroupActionRequest.recurrence()));
        }
        if (putScheduledUpdateGroupActionRequest.minSize() != null) {
            request.addParameter("MinSize", StringUtils.fromInteger((Integer)putScheduledUpdateGroupActionRequest.minSize()));
        }
        if (putScheduledUpdateGroupActionRequest.maxSize() != null) {
            request.addParameter("MaxSize", StringUtils.fromInteger((Integer)putScheduledUpdateGroupActionRequest.maxSize()));
        }
        if (putScheduledUpdateGroupActionRequest.desiredCapacity() != null) {
            request.addParameter("DesiredCapacity", StringUtils.fromInteger((Integer)putScheduledUpdateGroupActionRequest.desiredCapacity()));
        }
        return request;
    }
}

