/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SuspendedProcess
implements ToCopyableBuilder<Builder, SuspendedProcess> {
    private final String processName;
    private final String suspensionReason;

    private SuspendedProcess(BuilderImpl builder) {
        this.processName = builder.processName;
        this.suspensionReason = builder.suspensionReason;
    }

    public String processName() {
        return this.processName;
    }

    public String suspensionReason() {
        return this.suspensionReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.processName() == null ? 0 : this.processName().hashCode());
        hashCode = 31 * hashCode + (this.suspensionReason() == null ? 0 : this.suspensionReason().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuspendedProcess)) {
            return false;
        }
        SuspendedProcess other = (SuspendedProcess)obj;
        if (other.processName() == null ^ this.processName() == null) {
            return false;
        }
        if (other.processName() != null && !other.processName().equals(this.processName())) {
            return false;
        }
        if (other.suspensionReason() == null ^ this.suspensionReason() == null) {
            return false;
        }
        return other.suspensionReason() == null || other.suspensionReason().equals(this.suspensionReason());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.processName() != null) {
            sb.append("ProcessName: ").append(this.processName()).append(",");
        }
        if (this.suspensionReason() != null) {
            sb.append("SuspensionReason: ").append(this.suspensionReason()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String processName;
        private String suspensionReason;

        private BuilderImpl() {
        }

        private BuilderImpl(SuspendedProcess model) {
            this.setProcessName(model.processName);
            this.setSuspensionReason(model.suspensionReason);
        }

        public final String getProcessName() {
            return this.processName;
        }

        @Override
        public final Builder processName(String processName) {
            this.processName = processName;
            return this;
        }

        public final void setProcessName(String processName) {
            this.processName = processName;
        }

        public final String getSuspensionReason() {
            return this.suspensionReason;
        }

        @Override
        public final Builder suspensionReason(String suspensionReason) {
            this.suspensionReason = suspensionReason;
            return this;
        }

        public final void setSuspensionReason(String suspensionReason) {
            this.suspensionReason = suspensionReason;
        }

        public SuspendedProcess build() {
            return new SuspendedProcess(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SuspendedProcess> {
        public Builder processName(String var1);

        public Builder suspensionReason(String var1);
    }
}

