/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.autoscaling.model.MetricsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DisableMetricsCollectionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DisableMetricsCollectionRequest> {
    private final String autoScalingGroupName;
    private final List<String> metrics;

    private DisableMetricsCollectionRequest(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.metrics = builder.metrics;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public List<String> metrics() {
        return this.metrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.autoScalingGroupName() == null ? 0 : this.autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + (this.metrics() == null ? 0 : this.metrics().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableMetricsCollectionRequest)) {
            return false;
        }
        DisableMetricsCollectionRequest other = (DisableMetricsCollectionRequest)((Object)obj);
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.metrics() == null ^ this.metrics() == null) {
            return false;
        }
        return other.metrics() == null || other.metrics().equals(this.metrics());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(this.autoScalingGroupName()).append(",");
        }
        if (this.metrics() != null) {
            sb.append("Metrics: ").append(this.metrics()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private List<String> metrics;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableMetricsCollectionRequest model) {
            this.setAutoScalingGroupName(model.autoScalingGroupName);
            this.setMetrics(model.metrics);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Collection<String> getMetrics() {
            return this.metrics;
        }

        @Override
        public final Builder metrics(Collection<String> metrics) {
            this.metrics = MetricsCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(String ... metrics) {
            this.metrics(Arrays.asList(metrics));
            return this;
        }

        public final void setMetrics(Collection<String> metrics) {
            this.metrics = MetricsCopier.copy(metrics);
        }

        public DisableMetricsCollectionRequest build() {
            return new DisableMetricsCollectionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DisableMetricsCollectionRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder metrics(Collection<String> var1);

        public Builder metrics(String ... var1);
    }
}

