/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingGroup;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingGroupsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAutoScalingGroupsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeAutoScalingGroupsResponse> {
    private final List<AutoScalingGroup> autoScalingGroups;
    private final String nextToken;

    private DescribeAutoScalingGroupsResponse(BuilderImpl builder) {
        this.autoScalingGroups = builder.autoScalingGroups;
        this.nextToken = builder.nextToken;
    }

    public List<AutoScalingGroup> autoScalingGroups() {
        return this.autoScalingGroups;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.autoScalingGroups() == null ? 0 : this.autoScalingGroups().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAutoScalingGroupsResponse)) {
            return false;
        }
        DescribeAutoScalingGroupsResponse other = (DescribeAutoScalingGroupsResponse)((Object)obj);
        if (other.autoScalingGroups() == null ^ this.autoScalingGroups() == null) {
            return false;
        }
        if (other.autoScalingGroups() != null && !other.autoScalingGroups().equals(this.autoScalingGroups())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.autoScalingGroups() != null) {
            sb.append("AutoScalingGroups: ").append(this.autoScalingGroups()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<AutoScalingGroup> autoScalingGroups;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAutoScalingGroupsResponse model) {
            this.setAutoScalingGroups(model.autoScalingGroups);
            this.setNextToken(model.nextToken);
        }

        public final Collection<AutoScalingGroup> getAutoScalingGroups() {
            return this.autoScalingGroups;
        }

        @Override
        public final Builder autoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupsCopier.copy(autoScalingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroups(AutoScalingGroup ... autoScalingGroups) {
            this.autoScalingGroups(Arrays.asList(autoScalingGroups));
            return this;
        }

        public final void setAutoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupsCopier.copy(autoScalingGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeAutoScalingGroupsResponse build() {
            return new DescribeAutoScalingGroupsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeAutoScalingGroupsResponse> {
        public Builder autoScalingGroups(Collection<AutoScalingGroup> var1);

        public Builder autoScalingGroups(AutoScalingGroup ... var1);

        public Builder nextToken(String var1);
    }
}

