/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.autoscaling.model.SetDesiredCapacityRequest;
import software.amazon.awssdk.util.StringUtils;

public class SetDesiredCapacityRequestMarshaller
implements Marshaller<Request<SetDesiredCapacityRequest>, SetDesiredCapacityRequest> {
    public Request<SetDesiredCapacityRequest> marshall(SetDesiredCapacityRequest setDesiredCapacityRequest) {
        if (setDesiredCapacityRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setDesiredCapacityRequest, "AutoScalingClient");
        request.addParameter("Action", "SetDesiredCapacity");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setDesiredCapacityRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)setDesiredCapacityRequest.autoScalingGroupName()));
        }
        if (setDesiredCapacityRequest.desiredCapacity() != null) {
            request.addParameter("DesiredCapacity", StringUtils.fromInteger((Integer)setDesiredCapacityRequest.desiredCapacity()));
        }
        if (setDesiredCapacityRequest.honorCooldown() != null) {
            request.addParameter("HonorCooldown", StringUtils.fromBoolean((Boolean)setDesiredCapacityRequest.honorCooldown()));
        }
        return request;
    }
}

