/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.autoscaling.model.ActivityIdsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeScalingActivitiesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeScalingActivitiesRequest> {
    private final List<String> activityIds;
    private final String autoScalingGroupName;
    private final Integer maxRecords;
    private final String nextToken;

    private DescribeScalingActivitiesRequest(BuilderImpl builder) {
        this.activityIds = builder.activityIds;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.maxRecords = builder.maxRecords;
        this.nextToken = builder.nextToken;
    }

    public List<String> activityIds() {
        return this.activityIds;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.activityIds() == null ? 0 : this.activityIds().hashCode());
        hashCode = 31 * hashCode + (this.autoScalingGroupName() == null ? 0 : this.autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + (this.maxRecords() == null ? 0 : this.maxRecords().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingActivitiesRequest)) {
            return false;
        }
        DescribeScalingActivitiesRequest other = (DescribeScalingActivitiesRequest)((Object)obj);
        if (other.activityIds() == null ^ this.activityIds() == null) {
            return false;
        }
        if (other.activityIds() != null && !other.activityIds().equals(this.activityIds())) {
            return false;
        }
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.maxRecords() == null ^ this.maxRecords() == null) {
            return false;
        }
        if (other.maxRecords() != null && !other.maxRecords().equals(this.maxRecords())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.activityIds() != null) {
            sb.append("ActivityIds: ").append(this.activityIds()).append(",");
        }
        if (this.autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(this.autoScalingGroupName()).append(",");
        }
        if (this.maxRecords() != null) {
            sb.append("MaxRecords: ").append(this.maxRecords()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> activityIds;
        private String autoScalingGroupName;
        private Integer maxRecords;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalingActivitiesRequest model) {
            this.setActivityIds(model.activityIds);
            this.setAutoScalingGroupName(model.autoScalingGroupName);
            this.setMaxRecords(model.maxRecords);
            this.setNextToken(model.nextToken);
        }

        public final Collection<String> getActivityIds() {
            return this.activityIds;
        }

        @Override
        public final Builder activityIds(Collection<String> activityIds) {
            this.activityIds = ActivityIdsCopier.copy(activityIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activityIds(String ... activityIds) {
            this.activityIds(Arrays.asList(activityIds));
            return this;
        }

        public final void setActivityIds(Collection<String> activityIds) {
            this.activityIds = ActivityIdsCopier.copy(activityIds);
        }

        @SafeVarargs
        public final void setActivityIds(String ... activityIds) {
            this.activityIds(Arrays.asList(activityIds));
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeScalingActivitiesRequest build() {
            return new DescribeScalingActivitiesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeScalingActivitiesRequest> {
        public Builder activityIds(Collection<String> var1);

        public Builder activityIds(String ... var1);

        public Builder autoScalingGroupName(String var1);

        public Builder maxRecords(Integer var1);

        public Builder nextToken(String var1);
    }
}

