/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.signer.internal.chunkedencoding;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.internal.chunkedencoding.AwsChunkSigner;
import software.amazon.awssdk.auth.signer.internal.chunkedencoding.AwsChunkedEncodingConfig;
import software.amazon.awssdk.auth.signer.internal.chunkedencoding.ChunkContentIterator;
import software.amazon.awssdk.auth.signer.internal.chunkedencoding.DecodedStreamBuffer;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.io.SdkInputStream;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public final class AwsChunkedEncodingInputStream
extends SdkInputStream {
    private static final int SKIP_BUFFER_SIZE = 262144;
    private static final String CRLF = "\r\n";
    private static final String CHUNK_SIGNATURE_HEADER = ";chunk-signature=";
    private static final byte[] FINAL_CHUNK = new byte[0];
    private static final Logger log = Logger.loggerFor(AwsChunkedEncodingInputStream.class);
    private InputStream is = null;
    private final int chunkSize;
    private final int maxBufferSize;
    private final String headerSignature;
    private String previousChunkSignature;
    private final AwsChunkSigner chunkSigner;
    private ChunkContentIterator currentChunkIterator;
    private DecodedStreamBuffer decodedStreamBuffer;
    private boolean isAtStart = true;
    private boolean isTerminating = false;

    public AwsChunkedEncodingInputStream(InputStream in, String headerSignature, AwsChunkSigner chunkSigner, AwsChunkedEncodingConfig config) {
        int providedMaxBufferSize = config.bufferSize();
        if (in instanceof AwsChunkedEncodingInputStream) {
            AwsChunkedEncodingInputStream originalChunkedStream = (AwsChunkedEncodingInputStream)((Object)in);
            providedMaxBufferSize = Math.max(originalChunkedStream.maxBufferSize, providedMaxBufferSize);
            this.is = originalChunkedStream.is;
            this.decodedStreamBuffer = originalChunkedStream.decodedStreamBuffer;
        } else {
            this.is = in;
            this.decodedStreamBuffer = null;
        }
        this.chunkSize = config.chunkSize();
        this.maxBufferSize = providedMaxBufferSize;
        this.headerSignature = headerSignature;
        this.previousChunkSignature = headerSignature;
        this.chunkSigner = chunkSigner;
        if (this.maxBufferSize < this.chunkSize) {
            throw new IllegalArgumentException("Max buffer size should not be less than chunk size");
        }
    }

    public int read() throws IOException {
        byte[] tmp = new byte[1];
        int count = this.read(tmp, 0, 1);
        if (count != -1) {
            log.debug(() -> "One byte read from the stream.");
            int unsignedByte = tmp[0] & 0xFF;
            return unsignedByte;
        }
        return count;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int count;
        this.abortIfNeeded();
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (null == this.currentChunkIterator || !this.currentChunkIterator.hasNext()) {
            if (this.isTerminating) {
                return -1;
            }
            this.isTerminating = this.setUpNextChunk();
        }
        if ((count = this.currentChunkIterator.read(b, off, len)) > 0) {
            this.isAtStart = false;
            log.trace(() -> count + " byte read from the stream.");
        }
        return count;
    }

    public long skip(long n) throws IOException {
        long remaining;
        int count;
        if (n <= 0L) {
            return 0L;
        }
        int toskip = (int)Math.min(262144L, n);
        byte[] temp = new byte[toskip];
        for (remaining = n; remaining > 0L && (count = this.read(temp, 0, toskip)) >= 0; remaining -= (long)count) {
        }
        return n - remaining;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readlimit) {
        this.abortIfNeeded();
        if (!this.isAtStart) {
            throw new UnsupportedOperationException("Chunk-encoded stream only supports mark() at the start of the stream.");
        }
        if (this.is.markSupported()) {
            log.debug(() -> "AwsChunkedEncodingInputStream marked at the start of the stream (will directly mark the wrapped stream since it's mark-supported).");
            this.is.mark(readlimit);
        } else {
            log.debug(() -> "AwsChunkedEncodingInputStream marked at the start of the stream (initializing the buffer since the wrapped stream is not mark-supported).");
            this.decodedStreamBuffer = new DecodedStreamBuffer(this.maxBufferSize);
        }
    }

    public void reset() throws IOException {
        this.abortIfNeeded();
        this.currentChunkIterator = null;
        this.previousChunkSignature = this.headerSignature;
        if (this.is.markSupported()) {
            log.debug(() -> "AwsChunkedEncodingInputStream reset (will reset the wrapped stream because it is mark-supported).");
            this.is.reset();
        } else {
            log.debug(() -> "AwsChunkedEncodingInputStream reset (will use the buffer of the decoded stream).");
            if (null == this.decodedStreamBuffer) {
                throw new IOException("Cannot reset the stream because the mark is not set.");
            }
            this.decodedStreamBuffer.startReadBuffer();
        }
        this.currentChunkIterator = null;
        this.isAtStart = true;
        this.isTerminating = false;
    }

    public static long calculateStreamContentLength(long originalLength, int signatureLength, AwsChunkedEncodingConfig config) {
        if (originalLength < 0L) {
            throw new IllegalArgumentException("Nonnegative content length expected.");
        }
        int chunkSize = config.chunkSize();
        long maxSizeChunks = originalLength / (long)chunkSize;
        long remainingBytes = originalLength % (long)chunkSize;
        return maxSizeChunks * AwsChunkedEncodingInputStream.calculateSignedChunkLength(chunkSize, signatureLength) + (remainingBytes > 0L ? AwsChunkedEncodingInputStream.calculateSignedChunkLength(remainingBytes, signatureLength) : 0L) + AwsChunkedEncodingInputStream.calculateSignedChunkLength(0L, signatureLength);
    }

    private static long calculateSignedChunkLength(long chunkDataSize, int signatureLength) {
        return (long)(Long.toHexString(chunkDataSize).length() + CHUNK_SIGNATURE_HEADER.length() + signatureLength + CRLF.length()) + chunkDataSize + (long)CRLF.length();
    }

    private boolean setUpNextChunk() throws IOException {
        byte[] chunkData = new byte[this.chunkSize];
        int chunkSizeInBytes = 0;
        while (chunkSizeInBytes < this.chunkSize) {
            if (null != this.decodedStreamBuffer && this.decodedStreamBuffer.hasNext()) {
                chunkData[chunkSizeInBytes++] = this.decodedStreamBuffer.next();
                continue;
            }
            int bytesToRead = this.chunkSize - chunkSizeInBytes;
            int count = this.is.read(chunkData, chunkSizeInBytes, bytesToRead);
            if (count == -1) break;
            if (null != this.decodedStreamBuffer) {
                this.decodedStreamBuffer.buffer(chunkData, chunkSizeInBytes, count);
            }
            chunkSizeInBytes += count;
        }
        if (chunkSizeInBytes == 0) {
            byte[] signedFinalChunk = this.createSignedChunk(FINAL_CHUNK);
            this.currentChunkIterator = new ChunkContentIterator(signedFinalChunk);
            return true;
        }
        if (chunkSizeInBytes < chunkData.length) {
            chunkData = Arrays.copyOf(chunkData, chunkSizeInBytes);
        }
        byte[] signedChunkContent = this.createSignedChunk(chunkData);
        this.currentChunkIterator = new ChunkContentIterator(signedChunkContent);
        return false;
    }

    private byte[] createSignedChunk(byte[] chunkData) {
        try {
            byte[] header = this.createSignedChunkHeader(chunkData);
            byte[] trailer = CRLF.getBytes(StandardCharsets.UTF_8);
            byte[] signedChunk = new byte[header.length + chunkData.length + trailer.length];
            System.arraycopy(header, 0, signedChunk, 0, header.length);
            System.arraycopy(chunkData, 0, signedChunk, header.length, chunkData.length);
            System.arraycopy(trailer, 0, signedChunk, header.length + chunkData.length, trailer.length);
            return signedChunk;
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to sign the chunked data. " + e.getMessage()).cause((Throwable)e).build();
        }
    }

    private byte[] createSignedChunkHeader(byte[] chunkData) {
        String chunkSignature;
        this.previousChunkSignature = chunkSignature = this.chunkSigner.signChunk(chunkData, this.previousChunkSignature);
        StringBuilder chunkHeader = new StringBuilder();
        chunkHeader.append(Integer.toHexString(chunkData.length));
        chunkHeader.append(CHUNK_SIGNATURE_HEADER).append(chunkSignature).append(CRLF);
        return chunkHeader.toString().getBytes(StandardCharsets.UTF_8);
    }

    protected InputStream getWrappedInputStream() {
        return this.is;
    }
}

