/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.signer;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.auth.credentials.CredentialUtils;
import software.amazon.awssdk.auth.signer.internal.Aws4SignerRequestParams;
import software.amazon.awssdk.auth.signer.internal.BaseAws4Signer;
import software.amazon.awssdk.auth.signer.internal.DigestComputingSubscriber;
import software.amazon.awssdk.auth.signer.params.Aws4SignerParams;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.signer.AsyncSigner;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.utils.BinaryUtils;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkPublicApi
public final class AsyncAws4Signer
extends BaseAws4Signer
implements AsyncSigner {
    public CompletableFuture<SdkHttpFullRequest> sign(SdkHttpFullRequest request, AsyncRequestBody requestBody, ExecutionAttributes executionAttributes) {
        Aws4SignerParams signingParams = this.extractSignerParams(Aws4SignerParams.builder(), executionAttributes).build();
        return this.signWithBody(request, requestBody, signingParams);
    }

    public CompletableFuture<SdkHttpFullRequest> signWithBody(SdkHttpFullRequest request, AsyncRequestBody requestBody, Aws4SignerParams signingParams) {
        if (CredentialUtils.isAnonymous(signingParams.awsCredentials())) {
            return CompletableFuture.completedFuture(request);
        }
        DigestComputingSubscriber bodyDigester = DigestComputingSubscriber.forSha256();
        requestBody.subscribe((Subscriber)bodyDigester);
        CompletableFuture<byte[]> digestBytes = bodyDigester.digestBytes();
        CompletionStage signedReqFuture = digestBytes.thenApply(bodyHash -> {
            String digestHex = BinaryUtils.toHex((byte[])bodyHash);
            Aws4SignerRequestParams requestParams = new Aws4SignerRequestParams(signingParams);
            SdkHttpFullRequest.Builder builder = this.doSign(request, requestParams, signingParams, digestHex);
            return builder.build();
        });
        return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)signedReqFuture, digestBytes);
    }

    public static AsyncAws4Signer create() {
        return new AsyncAws4Signer();
    }
}

