/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.authcrt.signer.internal.chunkedencoding;

import java.nio.charset.StandardCharsets;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.internal.chunkedencoding.AwsChunkSigner;
import software.amazon.awssdk.authcrt.signer.internal.AwsCrt4aSigningAdapter;
import software.amazon.awssdk.crt.auth.signing.AwsSigningConfig;

@SdkInternalApi
public class AwsS3V4aChunkSigner
implements AwsChunkSigner {
    private static final int SIGNATURE_LENGTH = 144;
    private final AwsCrt4aSigningAdapter aws4aSigner;
    private final AwsSigningConfig signingConfig;

    public AwsS3V4aChunkSigner(AwsCrt4aSigningAdapter aws4aSigner, AwsSigningConfig signingConfig) {
        this.aws4aSigner = aws4aSigner;
        this.signingConfig = signingConfig;
    }

    public String signChunk(byte[] chunkData, String previousSignature) {
        byte[] chunkSignature = this.aws4aSigner.signChunk(chunkData, previousSignature.getBytes(StandardCharsets.UTF_8), this.signingConfig);
        return new String(chunkSignature, StandardCharsets.UTF_8);
    }

    public static int getSignatureLength() {
        return 144;
    }
}

