/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerRequest;
import software.amazon.awssdk.services.auditmanager.model.ControlStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAssessmentControlRequest
extends AuditManagerRequest
implements ToCopyableBuilder<Builder, UpdateAssessmentControlRequest> {
    private static final SdkField<String> ASSESSMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentId").getter(UpdateAssessmentControlRequest.getter(UpdateAssessmentControlRequest::assessmentId)).setter(UpdateAssessmentControlRequest.setter(Builder::assessmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assessmentId").build()}).build();
    private static final SdkField<String> CONTROL_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("controlSetId").getter(UpdateAssessmentControlRequest.getter(UpdateAssessmentControlRequest::controlSetId)).setter(UpdateAssessmentControlRequest.setter(Builder::controlSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("controlSetId").build()}).build();
    private static final SdkField<String> CONTROL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("controlId").getter(UpdateAssessmentControlRequest.getter(UpdateAssessmentControlRequest::controlId)).setter(UpdateAssessmentControlRequest.setter(Builder::controlId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("controlId").build()}).build();
    private static final SdkField<String> CONTROL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("controlStatus").getter(UpdateAssessmentControlRequest.getter(UpdateAssessmentControlRequest::controlStatusAsString)).setter(UpdateAssessmentControlRequest.setter(Builder::controlStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlStatus").build()}).build();
    private static final SdkField<String> COMMENT_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("commentBody").getter(UpdateAssessmentControlRequest.getter(UpdateAssessmentControlRequest::commentBody)).setter(UpdateAssessmentControlRequest.setter(Builder::commentBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commentBody").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_ID_FIELD, CONTROL_SET_ID_FIELD, CONTROL_ID_FIELD, CONTROL_STATUS_FIELD, COMMENT_BODY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAssessmentControlRequest.memberNameToFieldInitializer();
    private final String assessmentId;
    private final String controlSetId;
    private final String controlId;
    private final String controlStatus;
    private final String commentBody;

    private UpdateAssessmentControlRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentId = builder.assessmentId;
        this.controlSetId = builder.controlSetId;
        this.controlId = builder.controlId;
        this.controlStatus = builder.controlStatus;
        this.commentBody = builder.commentBody;
    }

    public final String assessmentId() {
        return this.assessmentId;
    }

    public final String controlSetId() {
        return this.controlSetId;
    }

    public final String controlId() {
        return this.controlId;
    }

    public final ControlStatus controlStatus() {
        return ControlStatus.fromValue(this.controlStatus);
    }

    public final String controlStatusAsString() {
        return this.controlStatus;
    }

    public final String commentBody() {
        return this.commentBody;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlId());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.commentBody());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssessmentControlRequest)) {
            return false;
        }
        UpdateAssessmentControlRequest other = (UpdateAssessmentControlRequest)((Object)obj);
        return Objects.equals(this.assessmentId(), other.assessmentId()) && Objects.equals(this.controlSetId(), other.controlSetId()) && Objects.equals(this.controlId(), other.controlId()) && Objects.equals(this.controlStatusAsString(), other.controlStatusAsString()) && Objects.equals(this.commentBody(), other.commentBody());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAssessmentControlRequest").add("AssessmentId", (Object)this.assessmentId()).add("ControlSetId", (Object)this.controlSetId()).add("ControlId", (Object)this.controlId()).add("ControlStatus", (Object)this.controlStatusAsString()).add("CommentBody", (Object)(this.commentBody() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessmentId": {
                return Optional.ofNullable(clazz.cast(this.assessmentId()));
            }
            case "controlSetId": {
                return Optional.ofNullable(clazz.cast(this.controlSetId()));
            }
            case "controlId": {
                return Optional.ofNullable(clazz.cast(this.controlId()));
            }
            case "controlStatus": {
                return Optional.ofNullable(clazz.cast(this.controlStatusAsString()));
            }
            case "commentBody": {
                return Optional.ofNullable(clazz.cast(this.commentBody()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("assessmentId", ASSESSMENT_ID_FIELD);
        map.put("controlSetId", CONTROL_SET_ID_FIELD);
        map.put("controlId", CONTROL_ID_FIELD);
        map.put("controlStatus", CONTROL_STATUS_FIELD);
        map.put("commentBody", COMMENT_BODY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAssessmentControlRequest, T> g) {
        return obj -> g.apply((UpdateAssessmentControlRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerRequest.BuilderImpl
    implements Builder {
        private String assessmentId;
        private String controlSetId;
        private String controlId;
        private String controlStatus;
        private String commentBody;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssessmentControlRequest model) {
            super(model);
            this.assessmentId(model.assessmentId);
            this.controlSetId(model.controlSetId);
            this.controlId(model.controlId);
            this.controlStatus(model.controlStatus);
            this.commentBody(model.commentBody);
        }

        public final String getAssessmentId() {
            return this.assessmentId;
        }

        public final void setAssessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
        }

        @Override
        public final Builder assessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
            return this;
        }

        public final String getControlSetId() {
            return this.controlSetId;
        }

        public final void setControlSetId(String controlSetId) {
            this.controlSetId = controlSetId;
        }

        @Override
        public final Builder controlSetId(String controlSetId) {
            this.controlSetId = controlSetId;
            return this;
        }

        public final String getControlId() {
            return this.controlId;
        }

        public final void setControlId(String controlId) {
            this.controlId = controlId;
        }

        @Override
        public final Builder controlId(String controlId) {
            this.controlId = controlId;
            return this;
        }

        public final String getControlStatus() {
            return this.controlStatus;
        }

        public final void setControlStatus(String controlStatus) {
            this.controlStatus = controlStatus;
        }

        @Override
        public final Builder controlStatus(String controlStatus) {
            this.controlStatus = controlStatus;
            return this;
        }

        @Override
        public final Builder controlStatus(ControlStatus controlStatus) {
            this.controlStatus(controlStatus == null ? null : controlStatus.toString());
            return this;
        }

        public final String getCommentBody() {
            return this.commentBody;
        }

        public final void setCommentBody(String commentBody) {
            this.commentBody = commentBody;
        }

        @Override
        public final Builder commentBody(String commentBody) {
            this.commentBody = commentBody;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAssessmentControlRequest build() {
            return new UpdateAssessmentControlRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AuditManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAssessmentControlRequest> {
        public Builder assessmentId(String var1);

        public Builder controlSetId(String var1);

        public Builder controlId(String var1);

        public Builder controlStatus(String var1);

        public Builder controlStatus(ControlStatus var1);

        public Builder commentBody(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

