/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.auditmanager.model.AssessmentFrameworkShareRequest;
import software.amazon.awssdk.services.auditmanager.model.AssessmentFrameworkShareRequestListCopier;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssessmentFrameworkShareRequestsResponse
extends AuditManagerResponse
implements ToCopyableBuilder<Builder, ListAssessmentFrameworkShareRequestsResponse> {
    private static final SdkField<List<AssessmentFrameworkShareRequest>> ASSESSMENT_FRAMEWORK_SHARE_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assessmentFrameworkShareRequests").getter(ListAssessmentFrameworkShareRequestsResponse.getter(ListAssessmentFrameworkShareRequestsResponse::assessmentFrameworkShareRequests)).setter(ListAssessmentFrameworkShareRequestsResponse.setter(Builder::assessmentFrameworkShareRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentFrameworkShareRequests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssessmentFrameworkShareRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAssessmentFrameworkShareRequestsResponse.getter(ListAssessmentFrameworkShareRequestsResponse::nextToken)).setter(ListAssessmentFrameworkShareRequestsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_FRAMEWORK_SHARE_REQUESTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAssessmentFrameworkShareRequestsResponse.memberNameToFieldInitializer();
    private final List<AssessmentFrameworkShareRequest> assessmentFrameworkShareRequests;
    private final String nextToken;

    private ListAssessmentFrameworkShareRequestsResponse(BuilderImpl builder) {
        super(builder);
        this.assessmentFrameworkShareRequests = builder.assessmentFrameworkShareRequests;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAssessmentFrameworkShareRequests() {
        return this.assessmentFrameworkShareRequests != null && !(this.assessmentFrameworkShareRequests instanceof SdkAutoConstructList);
    }

    public final List<AssessmentFrameworkShareRequest> assessmentFrameworkShareRequests() {
        return this.assessmentFrameworkShareRequests;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssessmentFrameworkShareRequests() ? this.assessmentFrameworkShareRequests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssessmentFrameworkShareRequestsResponse)) {
            return false;
        }
        ListAssessmentFrameworkShareRequestsResponse other = (ListAssessmentFrameworkShareRequestsResponse)((Object)obj);
        return this.hasAssessmentFrameworkShareRequests() == other.hasAssessmentFrameworkShareRequests() && Objects.equals(this.assessmentFrameworkShareRequests(), other.assessmentFrameworkShareRequests()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAssessmentFrameworkShareRequestsResponse").add("AssessmentFrameworkShareRequests", this.hasAssessmentFrameworkShareRequests() ? this.assessmentFrameworkShareRequests() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessmentFrameworkShareRequests": {
                return Optional.ofNullable(clazz.cast(this.assessmentFrameworkShareRequests()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assessmentFrameworkShareRequests", ASSESSMENT_FRAMEWORK_SHARE_REQUESTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAssessmentFrameworkShareRequestsResponse, T> g) {
        return obj -> g.apply((ListAssessmentFrameworkShareRequestsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerResponse.BuilderImpl
    implements Builder {
        private List<AssessmentFrameworkShareRequest> assessmentFrameworkShareRequests = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssessmentFrameworkShareRequestsResponse model) {
            super(model);
            this.assessmentFrameworkShareRequests(model.assessmentFrameworkShareRequests);
            this.nextToken(model.nextToken);
        }

        public final List<AssessmentFrameworkShareRequest.Builder> getAssessmentFrameworkShareRequests() {
            List<AssessmentFrameworkShareRequest.Builder> result = AssessmentFrameworkShareRequestListCopier.copyToBuilder(this.assessmentFrameworkShareRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssessmentFrameworkShareRequests(Collection<AssessmentFrameworkShareRequest.BuilderImpl> assessmentFrameworkShareRequests) {
            this.assessmentFrameworkShareRequests = AssessmentFrameworkShareRequestListCopier.copyFromBuilder(assessmentFrameworkShareRequests);
        }

        @Override
        public final Builder assessmentFrameworkShareRequests(Collection<AssessmentFrameworkShareRequest> assessmentFrameworkShareRequests) {
            this.assessmentFrameworkShareRequests = AssessmentFrameworkShareRequestListCopier.copy(assessmentFrameworkShareRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentFrameworkShareRequests(AssessmentFrameworkShareRequest ... assessmentFrameworkShareRequests) {
            this.assessmentFrameworkShareRequests(Arrays.asList(assessmentFrameworkShareRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentFrameworkShareRequests(Consumer<AssessmentFrameworkShareRequest.Builder> ... assessmentFrameworkShareRequests) {
            this.assessmentFrameworkShareRequests(Stream.of(assessmentFrameworkShareRequests).map(c -> (AssessmentFrameworkShareRequest)((AssessmentFrameworkShareRequest.Builder)AssessmentFrameworkShareRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAssessmentFrameworkShareRequestsResponse build() {
            return new ListAssessmentFrameworkShareRequestsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AuditManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssessmentFrameworkShareRequestsResponse> {
        public Builder assessmentFrameworkShareRequests(Collection<AssessmentFrameworkShareRequest> var1);

        public Builder assessmentFrameworkShareRequests(AssessmentFrameworkShareRequest ... var1);

        public Builder assessmentFrameworkShareRequests(Consumer<AssessmentFrameworkShareRequest.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

