/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvidenceInsights
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvidenceInsights> {
    private static final SdkField<Integer> NONCOMPLIANT_EVIDENCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("noncompliantEvidenceCount").getter(EvidenceInsights.getter(EvidenceInsights::noncompliantEvidenceCount)).setter(EvidenceInsights.setter(Builder::noncompliantEvidenceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noncompliantEvidenceCount").build()}).build();
    private static final SdkField<Integer> COMPLIANT_EVIDENCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("compliantEvidenceCount").getter(EvidenceInsights.getter(EvidenceInsights::compliantEvidenceCount)).setter(EvidenceInsights.setter(Builder::compliantEvidenceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compliantEvidenceCount").build()}).build();
    private static final SdkField<Integer> INCONCLUSIVE_EVIDENCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("inconclusiveEvidenceCount").getter(EvidenceInsights.getter(EvidenceInsights::inconclusiveEvidenceCount)).setter(EvidenceInsights.setter(Builder::inconclusiveEvidenceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inconclusiveEvidenceCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NONCOMPLIANT_EVIDENCE_COUNT_FIELD, COMPLIANT_EVIDENCE_COUNT_FIELD, INCONCLUSIVE_EVIDENCE_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvidenceInsights.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer noncompliantEvidenceCount;
    private final Integer compliantEvidenceCount;
    private final Integer inconclusiveEvidenceCount;

    private EvidenceInsights(BuilderImpl builder) {
        this.noncompliantEvidenceCount = builder.noncompliantEvidenceCount;
        this.compliantEvidenceCount = builder.compliantEvidenceCount;
        this.inconclusiveEvidenceCount = builder.inconclusiveEvidenceCount;
    }

    public final Integer noncompliantEvidenceCount() {
        return this.noncompliantEvidenceCount;
    }

    public final Integer compliantEvidenceCount() {
        return this.compliantEvidenceCount;
    }

    public final Integer inconclusiveEvidenceCount() {
        return this.inconclusiveEvidenceCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.noncompliantEvidenceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.compliantEvidenceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.inconclusiveEvidenceCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvidenceInsights)) {
            return false;
        }
        EvidenceInsights other = (EvidenceInsights)obj;
        return Objects.equals(this.noncompliantEvidenceCount(), other.noncompliantEvidenceCount()) && Objects.equals(this.compliantEvidenceCount(), other.compliantEvidenceCount()) && Objects.equals(this.inconclusiveEvidenceCount(), other.inconclusiveEvidenceCount());
    }

    public final String toString() {
        return ToString.builder((String)"EvidenceInsights").add("NoncompliantEvidenceCount", (Object)this.noncompliantEvidenceCount()).add("CompliantEvidenceCount", (Object)this.compliantEvidenceCount()).add("InconclusiveEvidenceCount", (Object)this.inconclusiveEvidenceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "noncompliantEvidenceCount": {
                return Optional.ofNullable(clazz.cast(this.noncompliantEvidenceCount()));
            }
            case "compliantEvidenceCount": {
                return Optional.ofNullable(clazz.cast(this.compliantEvidenceCount()));
            }
            case "inconclusiveEvidenceCount": {
                return Optional.ofNullable(clazz.cast(this.inconclusiveEvidenceCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Integer>> map = new HashMap<String, SdkField<Integer>>();
        map.put("noncompliantEvidenceCount", NONCOMPLIANT_EVIDENCE_COUNT_FIELD);
        map.put("compliantEvidenceCount", COMPLIANT_EVIDENCE_COUNT_FIELD);
        map.put("inconclusiveEvidenceCount", INCONCLUSIVE_EVIDENCE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvidenceInsights, T> g) {
        return obj -> g.apply((EvidenceInsights)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer noncompliantEvidenceCount;
        private Integer compliantEvidenceCount;
        private Integer inconclusiveEvidenceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(EvidenceInsights model) {
            this.noncompliantEvidenceCount(model.noncompliantEvidenceCount);
            this.compliantEvidenceCount(model.compliantEvidenceCount);
            this.inconclusiveEvidenceCount(model.inconclusiveEvidenceCount);
        }

        public final Integer getNoncompliantEvidenceCount() {
            return this.noncompliantEvidenceCount;
        }

        public final void setNoncompliantEvidenceCount(Integer noncompliantEvidenceCount) {
            this.noncompliantEvidenceCount = noncompliantEvidenceCount;
        }

        @Override
        public final Builder noncompliantEvidenceCount(Integer noncompliantEvidenceCount) {
            this.noncompliantEvidenceCount = noncompliantEvidenceCount;
            return this;
        }

        public final Integer getCompliantEvidenceCount() {
            return this.compliantEvidenceCount;
        }

        public final void setCompliantEvidenceCount(Integer compliantEvidenceCount) {
            this.compliantEvidenceCount = compliantEvidenceCount;
        }

        @Override
        public final Builder compliantEvidenceCount(Integer compliantEvidenceCount) {
            this.compliantEvidenceCount = compliantEvidenceCount;
            return this;
        }

        public final Integer getInconclusiveEvidenceCount() {
            return this.inconclusiveEvidenceCount;
        }

        public final void setInconclusiveEvidenceCount(Integer inconclusiveEvidenceCount) {
            this.inconclusiveEvidenceCount = inconclusiveEvidenceCount;
        }

        @Override
        public final Builder inconclusiveEvidenceCount(Integer inconclusiveEvidenceCount) {
            this.inconclusiveEvidenceCount = inconclusiveEvidenceCount;
            return this;
        }

        public EvidenceInsights build() {
            return new EvidenceInsights(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvidenceInsights> {
        public Builder noncompliantEvidenceCount(Integer var1);

        public Builder compliantEvidenceCount(Integer var1);

        public Builder inconclusiveEvidenceCount(Integer var1);
    }
}

