/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.auditmanager.model.AssessmentControl;
import software.amazon.awssdk.services.auditmanager.model.AssessmentControlsCopier;
import software.amazon.awssdk.services.auditmanager.model.ControlSetStatus;
import software.amazon.awssdk.services.auditmanager.model.Delegation;
import software.amazon.awssdk.services.auditmanager.model.DelegationsCopier;
import software.amazon.awssdk.services.auditmanager.model.Role;
import software.amazon.awssdk.services.auditmanager.model.RolesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssessmentControlSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssessmentControlSet> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(AssessmentControlSet.getter(AssessmentControlSet::id)).setter(AssessmentControlSet.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(AssessmentControlSet.getter(AssessmentControlSet::description)).setter(AssessmentControlSet.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AssessmentControlSet.getter(AssessmentControlSet::statusAsString)).setter(AssessmentControlSet.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<Role>> ROLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("roles").getter(AssessmentControlSet.getter(AssessmentControlSet::roles)).setter(AssessmentControlSet.setter(Builder::roles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Role::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AssessmentControl>> CONTROLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("controls").getter(AssessmentControlSet.getter(AssessmentControlSet::controls)).setter(AssessmentControlSet.setter(Builder::controls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssessmentControl::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Delegation>> DELEGATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("delegations").getter(AssessmentControlSet.getter(AssessmentControlSet::delegations)).setter(AssessmentControlSet.setter(Builder::delegations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("delegations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Delegation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> SYSTEM_EVIDENCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("systemEvidenceCount").getter(AssessmentControlSet.getter(AssessmentControlSet::systemEvidenceCount)).setter(AssessmentControlSet.setter(Builder::systemEvidenceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemEvidenceCount").build()}).build();
    private static final SdkField<Integer> MANUAL_EVIDENCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("manualEvidenceCount").getter(AssessmentControlSet.getter(AssessmentControlSet::manualEvidenceCount)).setter(AssessmentControlSet.setter(Builder::manualEvidenceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manualEvidenceCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, ROLES_FIELD, CONTROLS_FIELD, DELEGATIONS_FIELD, SYSTEM_EVIDENCE_COUNT_FIELD, MANUAL_EVIDENCE_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssessmentControlSet.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String description;
    private final String status;
    private final List<Role> roles;
    private final List<AssessmentControl> controls;
    private final List<Delegation> delegations;
    private final Integer systemEvidenceCount;
    private final Integer manualEvidenceCount;

    private AssessmentControlSet(BuilderImpl builder) {
        this.id = builder.id;
        this.description = builder.description;
        this.status = builder.status;
        this.roles = builder.roles;
        this.controls = builder.controls;
        this.delegations = builder.delegations;
        this.systemEvidenceCount = builder.systemEvidenceCount;
        this.manualEvidenceCount = builder.manualEvidenceCount;
    }

    public final String id() {
        return this.id;
    }

    public final String description() {
        return this.description;
    }

    public final ControlSetStatus status() {
        return ControlSetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasRoles() {
        return this.roles != null && !(this.roles instanceof SdkAutoConstructList);
    }

    public final List<Role> roles() {
        return this.roles;
    }

    public final boolean hasControls() {
        return this.controls != null && !(this.controls instanceof SdkAutoConstructList);
    }

    public final List<AssessmentControl> controls() {
        return this.controls;
    }

    public final boolean hasDelegations() {
        return this.delegations != null && !(this.delegations instanceof SdkAutoConstructList);
    }

    public final List<Delegation> delegations() {
        return this.delegations;
    }

    public final Integer systemEvidenceCount() {
        return this.systemEvidenceCount;
    }

    public final Integer manualEvidenceCount() {
        return this.manualEvidenceCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoles() ? this.roles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasControls() ? this.controls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDelegations() ? this.delegations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.systemEvidenceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.manualEvidenceCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentControlSet)) {
            return false;
        }
        AssessmentControlSet other = (AssessmentControlSet)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasRoles() == other.hasRoles() && Objects.equals(this.roles(), other.roles()) && this.hasControls() == other.hasControls() && Objects.equals(this.controls(), other.controls()) && this.hasDelegations() == other.hasDelegations() && Objects.equals(this.delegations(), other.delegations()) && Objects.equals(this.systemEvidenceCount(), other.systemEvidenceCount()) && Objects.equals(this.manualEvidenceCount(), other.manualEvidenceCount());
    }

    public final String toString() {
        return ToString.builder((String)"AssessmentControlSet").add("Id", (Object)this.id()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("Roles", (Object)(this.roles() == null ? null : "*** Sensitive Data Redacted ***")).add("Controls", this.hasControls() ? this.controls() : null).add("Delegations", (Object)(this.delegations() == null ? null : "*** Sensitive Data Redacted ***")).add("SystemEvidenceCount", (Object)this.systemEvidenceCount()).add("ManualEvidenceCount", (Object)this.manualEvidenceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "roles": {
                return Optional.ofNullable(clazz.cast(this.roles()));
            }
            case "controls": {
                return Optional.ofNullable(clazz.cast(this.controls()));
            }
            case "delegations": {
                return Optional.ofNullable(clazz.cast(this.delegations()));
            }
            case "systemEvidenceCount": {
                return Optional.ofNullable(clazz.cast(this.systemEvidenceCount()));
            }
            case "manualEvidenceCount": {
                return Optional.ofNullable(clazz.cast(this.manualEvidenceCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("roles", ROLES_FIELD);
        map.put("controls", CONTROLS_FIELD);
        map.put("delegations", DELEGATIONS_FIELD);
        map.put("systemEvidenceCount", SYSTEM_EVIDENCE_COUNT_FIELD);
        map.put("manualEvidenceCount", MANUAL_EVIDENCE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssessmentControlSet, T> g) {
        return obj -> g.apply((AssessmentControlSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String description;
        private String status;
        private List<Role> roles = DefaultSdkAutoConstructList.getInstance();
        private List<AssessmentControl> controls = DefaultSdkAutoConstructList.getInstance();
        private List<Delegation> delegations = DefaultSdkAutoConstructList.getInstance();
        private Integer systemEvidenceCount;
        private Integer manualEvidenceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentControlSet model) {
            this.id(model.id);
            this.description(model.description);
            this.status(model.status);
            this.roles(model.roles);
            this.controls(model.controls);
            this.delegations(model.delegations);
            this.systemEvidenceCount(model.systemEvidenceCount);
            this.manualEvidenceCount(model.manualEvidenceCount);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ControlSetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<Role.Builder> getRoles() {
            List<Role.Builder> result = RolesCopier.copyToBuilder(this.roles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoles(Collection<Role.BuilderImpl> roles) {
            this.roles = RolesCopier.copyFromBuilder(roles);
        }

        @Override
        public final Builder roles(Collection<Role> roles) {
            this.roles = RolesCopier.copy(roles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roles(Role ... roles) {
            this.roles(Arrays.asList(roles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roles(Consumer<Role.Builder> ... roles) {
            this.roles(Stream.of(roles).map(c -> (Role)((Role.Builder)Role.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AssessmentControl.Builder> getControls() {
            List<AssessmentControl.Builder> result = AssessmentControlsCopier.copyToBuilder(this.controls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setControls(Collection<AssessmentControl.BuilderImpl> controls) {
            this.controls = AssessmentControlsCopier.copyFromBuilder(controls);
        }

        @Override
        public final Builder controls(Collection<AssessmentControl> controls) {
            this.controls = AssessmentControlsCopier.copy(controls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controls(AssessmentControl ... controls) {
            this.controls(Arrays.asList(controls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controls(Consumer<AssessmentControl.Builder> ... controls) {
            this.controls(Stream.of(controls).map(c -> (AssessmentControl)((AssessmentControl.Builder)AssessmentControl.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Delegation.Builder> getDelegations() {
            List<Delegation.Builder> result = DelegationsCopier.copyToBuilder(this.delegations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDelegations(Collection<Delegation.BuilderImpl> delegations) {
            this.delegations = DelegationsCopier.copyFromBuilder(delegations);
        }

        @Override
        public final Builder delegations(Collection<Delegation> delegations) {
            this.delegations = DelegationsCopier.copy(delegations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder delegations(Delegation ... delegations) {
            this.delegations(Arrays.asList(delegations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder delegations(Consumer<Delegation.Builder> ... delegations) {
            this.delegations(Stream.of(delegations).map(c -> (Delegation)((Delegation.Builder)Delegation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getSystemEvidenceCount() {
            return this.systemEvidenceCount;
        }

        public final void setSystemEvidenceCount(Integer systemEvidenceCount) {
            this.systemEvidenceCount = systemEvidenceCount;
        }

        @Override
        public final Builder systemEvidenceCount(Integer systemEvidenceCount) {
            this.systemEvidenceCount = systemEvidenceCount;
            return this;
        }

        public final Integer getManualEvidenceCount() {
            return this.manualEvidenceCount;
        }

        public final void setManualEvidenceCount(Integer manualEvidenceCount) {
            this.manualEvidenceCount = manualEvidenceCount;
        }

        @Override
        public final Builder manualEvidenceCount(Integer manualEvidenceCount) {
            this.manualEvidenceCount = manualEvidenceCount;
            return this;
        }

        public AssessmentControlSet build() {
            return new AssessmentControlSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssessmentControlSet> {
        public Builder id(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(ControlSetStatus var1);

        public Builder roles(Collection<Role> var1);

        public Builder roles(Role ... var1);

        public Builder roles(Consumer<Role.Builder> ... var1);

        public Builder controls(Collection<AssessmentControl> var1);

        public Builder controls(AssessmentControl ... var1);

        public Builder controls(Consumer<AssessmentControl.Builder> ... var1);

        public Builder delegations(Collection<Delegation> var1);

        public Builder delegations(Delegation ... var1);

        public Builder delegations(Consumer<Delegation.Builder> ... var1);

        public Builder systemEvidenceCount(Integer var1);

        public Builder manualEvidenceCount(Integer var1);
    }
}

