/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.auditmanager.AuditManagerClient;
import software.amazon.awssdk.services.auditmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainRequest;
import software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainResponse;

public class ListControlInsightsByControlDomainIterable
implements SdkIterable<ListControlInsightsByControlDomainResponse> {
    private final AuditManagerClient client;
    private final ListControlInsightsByControlDomainRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListControlInsightsByControlDomainIterable(AuditManagerClient client, ListControlInsightsByControlDomainRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListControlInsightsByControlDomainResponseFetcher();
    }

    public Iterator<ListControlInsightsByControlDomainResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListControlInsightsByControlDomainResponseFetcher
    implements SyncPageFetcher<ListControlInsightsByControlDomainResponse> {
        private ListControlInsightsByControlDomainResponseFetcher() {
        }

        public boolean hasNextPage(ListControlInsightsByControlDomainResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListControlInsightsByControlDomainResponse nextPage(ListControlInsightsByControlDomainResponse previousPage) {
            if (previousPage == null) {
                return ListControlInsightsByControlDomainIterable.this.client.listControlInsightsByControlDomain(ListControlInsightsByControlDomainIterable.this.firstRequest);
            }
            return ListControlInsightsByControlDomainIterable.this.client.listControlInsightsByControlDomain((ListControlInsightsByControlDomainRequest)((Object)ListControlInsightsByControlDomainIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

