/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.auditmanager.AuditManagerAsyncClient;
import software.amazon.awssdk.services.auditmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainRequest;
import software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse;

public class ListAssessmentControlInsightsByControlDomainPublisher
implements SdkPublisher<ListAssessmentControlInsightsByControlDomainResponse> {
    private final AuditManagerAsyncClient client;
    private final ListAssessmentControlInsightsByControlDomainRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssessmentControlInsightsByControlDomainPublisher(AuditManagerAsyncClient client, ListAssessmentControlInsightsByControlDomainRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssessmentControlInsightsByControlDomainPublisher(AuditManagerAsyncClient client, ListAssessmentControlInsightsByControlDomainRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssessmentControlInsightsByControlDomainResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssessmentControlInsightsByControlDomainResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAssessmentControlInsightsByControlDomainResponseFetcher
    implements AsyncPageFetcher<ListAssessmentControlInsightsByControlDomainResponse> {
        private ListAssessmentControlInsightsByControlDomainResponseFetcher() {
        }

        public boolean hasNextPage(ListAssessmentControlInsightsByControlDomainResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAssessmentControlInsightsByControlDomainResponse> nextPage(ListAssessmentControlInsightsByControlDomainResponse previousPage) {
            if (previousPage == null) {
                return ListAssessmentControlInsightsByControlDomainPublisher.this.client.listAssessmentControlInsightsByControlDomain(ListAssessmentControlInsightsByControlDomainPublisher.this.firstRequest);
            }
            return ListAssessmentControlInsightsByControlDomainPublisher.this.client.listAssessmentControlInsightsByControlDomain((ListAssessmentControlInsightsByControlDomainRequest)((Object)ListAssessmentControlInsightsByControlDomainPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

