/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A finalized document that's generated from an Audit Manager assessment. These reports summarize the relevant evidence
 * that was collected for your audit, and link to the relevant evidence folders. These evidence folders are named and
 * organized according to the controls that are specified in your assessment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssessmentReport implements SdkPojo, Serializable,
        ToCopyableBuilder<AssessmentReport.Builder, AssessmentReport> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(AssessmentReport::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AssessmentReport::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AssessmentReport::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountId").getter(getter(AssessmentReport::awsAccountId)).setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()).build();

    private static final SdkField<String> ASSESSMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentId").getter(getter(AssessmentReport::assessmentId)).setter(setter(Builder::assessmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentId").build()).build();

    private static final SdkField<String> ASSESSMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentName").getter(getter(AssessmentReport::assessmentName))
            .setter(setter(Builder::assessmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentName").build()).build();

    private static final SdkField<String> AUTHOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("author")
            .getter(getter(AssessmentReport::author)).setter(setter(Builder::author))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("author").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AssessmentReport::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(AssessmentReport::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, AWS_ACCOUNT_ID_FIELD, ASSESSMENT_ID_FIELD, ASSESSMENT_NAME_FIELD, AUTHOR_FIELD, STATUS_FIELD,
            CREATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String description;

    private final String awsAccountId;

    private final String assessmentId;

    private final String assessmentName;

    private final String author;

    private final String status;

    private final Instant creationTime;

    private AssessmentReport(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.awsAccountId = builder.awsAccountId;
        this.assessmentId = builder.assessmentId;
        this.assessmentName = builder.assessmentName;
        this.author = builder.author;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The unique identifier for the assessment report.
     * </p>
     * 
     * @return The unique identifier for the assessment report.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name that's given to the assessment report.
     * </p>
     * 
     * @return The name that's given to the assessment report.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the specified assessment report.
     * </p>
     * 
     * @return The description of the specified assessment report.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier for the specified Amazon Web Services account.
     * </p>
     * 
     * @return The identifier for the specified Amazon Web Services account.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The identifier for the specified assessment.
     * </p>
     * 
     * @return The identifier for the specified assessment.
     */
    public final String assessmentId() {
        return assessmentId;
    }

    /**
     * <p>
     * The name of the associated assessment.
     * </p>
     * 
     * @return The name of the associated assessment.
     */
    public final String assessmentName() {
        return assessmentName;
    }

    /**
     * <p>
     * The name of the user who created the assessment report.
     * </p>
     * 
     * @return The name of the user who created the assessment report.
     */
    public final String author() {
        return author;
    }

    /**
     * <p>
     * The current status of the specified assessment report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AssessmentReportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the specified assessment report.
     * @see AssessmentReportStatus
     */
    public final AssessmentReportStatus status() {
        return AssessmentReportStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the specified assessment report.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AssessmentReportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the specified assessment report.
     * @see AssessmentReportStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Specifies when the assessment report was created.
     * </p>
     * 
     * @return Specifies when the assessment report was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentId());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentName());
        hashCode = 31 * hashCode + Objects.hashCode(author());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentReport)) {
            return false;
        }
        AssessmentReport other = (AssessmentReport) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(assessmentId(), other.assessmentId())
                && Objects.equals(assessmentName(), other.assessmentName()) && Objects.equals(author(), other.author())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssessmentReport").add("Id", id()).add("Name", name()).add("Description", description())
                .add("AwsAccountId", awsAccountId()).add("AssessmentId", assessmentId()).add("AssessmentName", assessmentName())
                .add("Author", author()).add("Status", statusAsString()).add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "awsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "assessmentId":
            return Optional.ofNullable(clazz.cast(assessmentId()));
        case "assessmentName":
            return Optional.ofNullable(clazz.cast(assessmentName()));
        case "author":
            return Optional.ofNullable(clazz.cast(author()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssessmentReport, T> g) {
        return obj -> g.apply((AssessmentReport) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssessmentReport> {
        /**
         * <p>
         * The unique identifier for the assessment report.
         * </p>
         * 
         * @param id
         *        The unique identifier for the assessment report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name that's given to the assessment report.
         * </p>
         * 
         * @param name
         *        The name that's given to the assessment report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the specified assessment report.
         * </p>
         * 
         * @param description
         *        The description of the specified assessment report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier for the specified Amazon Web Services account.
         * </p>
         * 
         * @param awsAccountId
         *        The identifier for the specified Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The identifier for the specified assessment.
         * </p>
         * 
         * @param assessmentId
         *        The identifier for the specified assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentId(String assessmentId);

        /**
         * <p>
         * The name of the associated assessment.
         * </p>
         * 
         * @param assessmentName
         *        The name of the associated assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentName(String assessmentName);

        /**
         * <p>
         * The name of the user who created the assessment report.
         * </p>
         * 
         * @param author
         *        The name of the user who created the assessment report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder author(String author);

        /**
         * <p>
         * The current status of the specified assessment report.
         * </p>
         * 
         * @param status
         *        The current status of the specified assessment report.
         * @see AssessmentReportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssessmentReportStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the specified assessment report.
         * </p>
         * 
         * @param status
         *        The current status of the specified assessment report.
         * @see AssessmentReportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssessmentReportStatus
         */
        Builder status(AssessmentReportStatus status);

        /**
         * <p>
         * Specifies when the assessment report was created.
         * </p>
         * 
         * @param creationTime
         *        Specifies when the assessment report was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String description;

        private String awsAccountId;

        private String assessmentId;

        private String assessmentName;

        private String author;

        private String status;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentReport model) {
            id(model.id);
            name(model.name);
            description(model.description);
            awsAccountId(model.awsAccountId);
            assessmentId(model.assessmentId);
            assessmentName(model.assessmentName);
            author(model.author);
            status(model.status);
            creationTime(model.creationTime);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAssessmentId() {
            return assessmentId;
        }

        public final void setAssessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
        }

        @Override
        public final Builder assessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
            return this;
        }

        public final String getAssessmentName() {
            return assessmentName;
        }

        public final void setAssessmentName(String assessmentName) {
            this.assessmentName = assessmentName;
        }

        @Override
        public final Builder assessmentName(String assessmentName) {
            this.assessmentName = assessmentName;
            return this;
        }

        public final String getAuthor() {
            return author;
        }

        public final void setAuthor(String author) {
            this.author = author;
        }

        @Override
        public final Builder author(String author) {
            this.author = author;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AssessmentReportStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public AssessmentReport build() {
            return new AssessmentReport(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
