/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.auditmanager.model.AssessmentReportsDestination;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerRequest;
import software.amazon.awssdk.services.auditmanager.model.Role;
import software.amazon.awssdk.services.auditmanager.model.RolesCopier;
import software.amazon.awssdk.services.auditmanager.model.Scope;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAssessmentRequest
extends AuditManagerRequest
implements ToCopyableBuilder<Builder, UpdateAssessmentRequest> {
    private static final SdkField<String> ASSESSMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentId").getter(UpdateAssessmentRequest.getter(UpdateAssessmentRequest::assessmentId)).setter(UpdateAssessmentRequest.setter(Builder::assessmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assessmentId").build()}).build();
    private static final SdkField<String> ASSESSMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentName").getter(UpdateAssessmentRequest.getter(UpdateAssessmentRequest::assessmentName)).setter(UpdateAssessmentRequest.setter(Builder::assessmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentName").build()}).build();
    private static final SdkField<String> ASSESSMENT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentDescription").getter(UpdateAssessmentRequest.getter(UpdateAssessmentRequest::assessmentDescription)).setter(UpdateAssessmentRequest.setter(Builder::assessmentDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentDescription").build()}).build();
    private static final SdkField<Scope> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scope").getter(UpdateAssessmentRequest.getter(UpdateAssessmentRequest::scope)).setter(UpdateAssessmentRequest.setter(Builder::scope)).constructor(Scope::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()}).build();
    private static final SdkField<AssessmentReportsDestination> ASSESSMENT_REPORTS_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("assessmentReportsDestination").getter(UpdateAssessmentRequest.getter(UpdateAssessmentRequest::assessmentReportsDestination)).setter(UpdateAssessmentRequest.setter(Builder::assessmentReportsDestination)).constructor(AssessmentReportsDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentReportsDestination").build()}).build();
    private static final SdkField<List<Role>> ROLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("roles").getter(UpdateAssessmentRequest.getter(UpdateAssessmentRequest::roles)).setter(UpdateAssessmentRequest.setter(Builder::roles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Role::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_ID_FIELD, ASSESSMENT_NAME_FIELD, ASSESSMENT_DESCRIPTION_FIELD, SCOPE_FIELD, ASSESSMENT_REPORTS_DESTINATION_FIELD, ROLES_FIELD));
    private final String assessmentId;
    private final String assessmentName;
    private final String assessmentDescription;
    private final Scope scope;
    private final AssessmentReportsDestination assessmentReportsDestination;
    private final List<Role> roles;

    private UpdateAssessmentRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentId = builder.assessmentId;
        this.assessmentName = builder.assessmentName;
        this.assessmentDescription = builder.assessmentDescription;
        this.scope = builder.scope;
        this.assessmentReportsDestination = builder.assessmentReportsDestination;
        this.roles = builder.roles;
    }

    public final String assessmentId() {
        return this.assessmentId;
    }

    public final String assessmentName() {
        return this.assessmentName;
    }

    public final String assessmentDescription() {
        return this.assessmentDescription;
    }

    public final Scope scope() {
        return this.scope;
    }

    public final AssessmentReportsDestination assessmentReportsDestination() {
        return this.assessmentReportsDestination;
    }

    public final boolean hasRoles() {
        return this.roles != null && !(this.roles instanceof SdkAutoConstructList);
    }

    public final List<Role> roles() {
        return this.roles;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.scope());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentReportsDestination());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoles() ? this.roles() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssessmentRequest)) {
            return false;
        }
        UpdateAssessmentRequest other = (UpdateAssessmentRequest)((Object)obj);
        return Objects.equals(this.assessmentId(), other.assessmentId()) && Objects.equals(this.assessmentName(), other.assessmentName()) && Objects.equals(this.assessmentDescription(), other.assessmentDescription()) && Objects.equals(this.scope(), other.scope()) && Objects.equals(this.assessmentReportsDestination(), other.assessmentReportsDestination()) && this.hasRoles() == other.hasRoles() && Objects.equals(this.roles(), other.roles());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAssessmentRequest").add("AssessmentId", (Object)this.assessmentId()).add("AssessmentName", (Object)this.assessmentName()).add("AssessmentDescription", (Object)this.assessmentDescription()).add("Scope", (Object)this.scope()).add("AssessmentReportsDestination", (Object)this.assessmentReportsDestination()).add("Roles", this.hasRoles() ? this.roles() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessmentId": {
                return Optional.ofNullable(clazz.cast(this.assessmentId()));
            }
            case "assessmentName": {
                return Optional.ofNullable(clazz.cast(this.assessmentName()));
            }
            case "assessmentDescription": {
                return Optional.ofNullable(clazz.cast(this.assessmentDescription()));
            }
            case "scope": {
                return Optional.ofNullable(clazz.cast(this.scope()));
            }
            case "assessmentReportsDestination": {
                return Optional.ofNullable(clazz.cast(this.assessmentReportsDestination()));
            }
            case "roles": {
                return Optional.ofNullable(clazz.cast(this.roles()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAssessmentRequest, T> g) {
        return obj -> g.apply((UpdateAssessmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerRequest.BuilderImpl
    implements Builder {
        private String assessmentId;
        private String assessmentName;
        private String assessmentDescription;
        private Scope scope;
        private AssessmentReportsDestination assessmentReportsDestination;
        private List<Role> roles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssessmentRequest model) {
            super(model);
            this.assessmentId(model.assessmentId);
            this.assessmentName(model.assessmentName);
            this.assessmentDescription(model.assessmentDescription);
            this.scope(model.scope);
            this.assessmentReportsDestination(model.assessmentReportsDestination);
            this.roles(model.roles);
        }

        public final String getAssessmentId() {
            return this.assessmentId;
        }

        public final void setAssessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
        }

        @Override
        public final Builder assessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
            return this;
        }

        public final String getAssessmentName() {
            return this.assessmentName;
        }

        public final void setAssessmentName(String assessmentName) {
            this.assessmentName = assessmentName;
        }

        @Override
        public final Builder assessmentName(String assessmentName) {
            this.assessmentName = assessmentName;
            return this;
        }

        public final String getAssessmentDescription() {
            return this.assessmentDescription;
        }

        public final void setAssessmentDescription(String assessmentDescription) {
            this.assessmentDescription = assessmentDescription;
        }

        @Override
        public final Builder assessmentDescription(String assessmentDescription) {
            this.assessmentDescription = assessmentDescription;
            return this;
        }

        public final Scope.Builder getScope() {
            return this.scope != null ? this.scope.toBuilder() : null;
        }

        public final void setScope(Scope.BuilderImpl scope) {
            this.scope = scope != null ? scope.build() : null;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public final AssessmentReportsDestination.Builder getAssessmentReportsDestination() {
            return this.assessmentReportsDestination != null ? this.assessmentReportsDestination.toBuilder() : null;
        }

        public final void setAssessmentReportsDestination(AssessmentReportsDestination.BuilderImpl assessmentReportsDestination) {
            this.assessmentReportsDestination = assessmentReportsDestination != null ? assessmentReportsDestination.build() : null;
        }

        @Override
        public final Builder assessmentReportsDestination(AssessmentReportsDestination assessmentReportsDestination) {
            this.assessmentReportsDestination = assessmentReportsDestination;
            return this;
        }

        public final List<Role.Builder> getRoles() {
            List<Role.Builder> result = RolesCopier.copyToBuilder(this.roles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoles(Collection<Role.BuilderImpl> roles) {
            this.roles = RolesCopier.copyFromBuilder(roles);
        }

        @Override
        public final Builder roles(Collection<Role> roles) {
            this.roles = RolesCopier.copy(roles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roles(Role ... roles) {
            this.roles(Arrays.asList(roles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roles(Consumer<Role.Builder> ... roles) {
            this.roles(Stream.of(roles).map(c -> (Role)((Role.Builder)Role.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAssessmentRequest build() {
            return new UpdateAssessmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AuditManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAssessmentRequest> {
        public Builder assessmentId(String var1);

        public Builder assessmentName(String var1);

        public Builder assessmentDescription(String var1);

        public Builder scope(Scope var1);

        default public Builder scope(Consumer<Scope.Builder> scope) {
            return this.scope((Scope)((Scope.Builder)Scope.builder().applyMutation(scope)).build());
        }

        public Builder assessmentReportsDestination(AssessmentReportsDestination var1);

        default public Builder assessmentReportsDestination(Consumer<AssessmentReportsDestination.Builder> assessmentReportsDestination) {
            return this.assessmentReportsDestination((AssessmentReportsDestination)((AssessmentReportsDestination.Builder)AssessmentReportsDestination.builder().applyMutation(assessmentReportsDestination)).build());
        }

        public Builder roles(Collection<Role> var1);

        public Builder roles(Role ... var1);

        public Builder roles(Consumer<Role.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

